<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Service\Admin\Core\SettingService;
use Illuminate\Support\Facades\DB;

class CronController extends Controller
{
    public SettingService $settingService;
    
    public function __construct(SettingService $settingService) {
        
        $this->settingService = $settingService;
    }

    public function run(): void {

        $lastResetTime = site_settings("last_reset_time");
        $differenceInSeconds = 0;
    
        if ($lastResetTime !== null) {
            $differenceInSeconds = Carbon::now()->diffInSeconds(Carbon::parse($lastResetTime));
        } else {
            $differenceInSeconds = config('demo.time_interval');
        }
    
        if (env('APP_MODE') == 'demo' && $differenceInSeconds >= config('demo.time_interval')) {
            $this->resetDatabase();
            $this->settingService->updateSettings([
                "last_reset_time" => Carbon::now()
            ]);
        }
    
        $this->settingService->updateSettings([
            "last_cron_run" => Carbon::now()
        ]);
    }

    private function resetDatabase() {

        try {

            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $tables = DB::select('SHOW TABLES');
            foreach ($tables as $table) {

                $table_name = $table->{'Tables_in_' . env('DB_DATABASE')};
                $escaped_table_name = "`$table_name`";
                DB::statement("DROP TABLE IF EXISTS $escaped_table_name");
            }
        
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        
            $sqlFilePath = base_path('resources/database/database.sql');
        
            if (file_exists($sqlFilePath)) {

                DB::unprepared(file_get_contents($sqlFilePath));
                optimize_clear();
            } else {
                
                throw new \Exception("Database SQL file not found: $sqlFilePath");
            }
        } catch(\Exception $e) {

           
        } 
    }
    
}
