<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?> 

<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2><?php echo e($title); ?></h2>
                <div class="breadcrumb-wrapper">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
                    </ol>
                </nav>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-body pt-0">
                <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
                    <?php echo csrf_field(); ?>
					<div class="form-element">
						<div class="row gy-4">
						  <div class="col-xxl-2 col-xl-3">
							<h5 class="form-element-title"><?php echo e(translate("Meta details")); ?></h5>
						  </div>
						  <div class="col-xxl-8 col-xl-9">
							<div class="row gy-4">
							  <div class="col-md-6">
								<div class="form-inner">
								  <label for="meta_title" class="form-label"> <?php echo e(translate("Meta Title")); ?> <small class="text-danger">*</small></label>
								  <input type="text" id="meta_title" name="site_settings[meta_title]" class="form-control" placeholder="<?php echo e(translate('Enter meta title')); ?>" aria-label="<?php echo e(translate('Meta Title')); ?>" value="<?php echo e(site_settings("meta_title")); ?>"/>
								</div>
							  </div>
							  <div class="col-md-6">
								<div class="form-inner">
									<label for="meta_keywords" class="form-label"><?php echo e(translate("Meta Keywords")); ?></label>
									<select data-placeholder="<?php echo e(translate('Select Meta Keywords')); ?>" class="form-select select2-search" data-show="5" name="site_settings[meta_keywords][]"  id="meta_keywords" multiple>
										<option value=""></option>
										<?php $__currentLoopData = json_decode(site_settings('meta_keywords'), true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option <?php echo e(in_array($file_type, json_decode(site_settings("meta_keywords"), true)) ? "selected" :""); ?> value="<?php echo e($file_type); ?>">
												<?php echo e($file_type); ?>

											</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							  </div>
							  <div class="col-md-12">
								<div class="form-inner">
								  <label for="meta_description" class="form-label"> <?php echo e(translate("Meta Description")); ?> </label>
								  <textarea class="form-control" name="site_settings[meta_description]" id="meta_description" rows="2" placeholder="<?php echo e(translate('Enter meta description')); ?>" aria-label="<?php echo e(translate('Meta Description')); ?>"><?php echo e(site_settings("meta_description")); ?></textarea>
								</div>
							  </div>
							</div>
						  </div>
						</div>
					</div>

                    <div class="row">
                        <div class="col-xxl-10">
                            <div class="form-action justify-content-end">
                            <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                            <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>
<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>  
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
		select2_search($('.select2-search').data('placeholder'), null, true);
        $(document).ready(function() {
           
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/setting/seo.blade.php ENDPATH**/ ?>