
<?php $__env->startSection("panel"); ?>
  
  <main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
              <h2><?php echo e($title); ?> </h2>
            </div>
        </div>
        <div class="row g-4 mb-4">
            <div class="col-xl-4 col-md-6">
              <div class="card credit-card">
                <div class="card-body d-flex align-items-center justify-content-between flex-wrap">
                  <div class="credit-card-left">
                    <div class="credit-count">
                      <span class="fs-3 text-info">
                        <i class="ri-message-2-line"></i>
                      </span>
                      <h6><?php echo e(auth()->user()->sms_credit == -1 ? translate("Unlimited") : formatNumber(auth()->user()->sms_credit) ?? translate("N\A")); ?></h6>
                    </div>
                    <p><?php echo e(translate("SMS Credit")); ?></p>
                  </div>
                  <div>
                    <a href="<?php echo e(route('user.plan.create')); ?>" class="i-btn btn--primary btn--md"> <?php echo e(translate("Buy Credit")); ?> </a>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-4 col-md-6">
              <div class="card credit-card">
                <div class="card-body d-flex align-items-center justify-content-between flex-wrap">
                  <div class="credit-card-left">
                    <div class="credit-count">
                      <span class="fs-3 text-danger">
                        <i class="ri-mail-line"></i>
                      </span>
                      <h6><?php echo e(auth()->user()->email_credit == -1 ? translate("Unlimited") : formatNumber(auth()->user()->email_credit) ?? translate("N\A")); ?></h6>
                    </div>
                    <p><?php echo e(translate("Email Credit")); ?></p>
                  </div>
                  <div>
                    <a href="<?php echo e(route('user.plan.create')); ?>" class="i-btn btn--primary btn--md"> <?php echo e(translate("Buy Credit")); ?> </a>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xl-4 col-md-6">
              <div class="card credit-card">
                <div class="card-body d-flex align-items-center justify-content-between flex-wrap gap-4">
                  <div class="credit-card-left">
                    <div class="credit-count">
                      <span class="fs-3 text-success">
                        <i class="ri-whatsapp-line"></i>
                      </span>
                      <h6><?php echo e(auth()->user()->whatsapp_credit == -1 ? translate("Unlimited") : formatNumber(auth()->user()->whatsapp_credit) ?? translate("N\A")); ?></h6>
                    </div>
                    <p><?php echo e(translate("Whatsapp Credit")); ?></p>
                  </div>
                  <div>
                    <a href="<?php echo e(route('user.plan.create')); ?>" class="i-btn btn--primary btn--md"> <?php echo e(translate("Buy Credit")); ?> </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
  
      <div class="row g-4">
        <div class="col-12">
          <div class="row g-4">
            <div class="col-xxl-10 order-lg-1 order-xxl-0">
              <div class="row g-4">
                <div class="col-xxl-4 col-xl-4">
                  <div class="card feature-card">
                    <div class="card-header pb-0">
                      <div class="card-header-left">
                        <h4 class="card-title"><?php echo e(translate("SMS Statistics")); ?></h4>
                      </div>
                      <div class="card-header-right">
                        <span class="fs-3 text-info">
                          <i class="ri-message-2-line"></i>
                        </span>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="row g-3">
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-primary">
                                <i class="ri-message-2-line"></i>
                              </span>
                              <small><?php echo e(translate("Total")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs['sms']['all'])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-success">
                                <i class="ri-mail-check-line"></i>
                              </span>
                              <small><?php echo e(translate("Success")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs['sms']['success'])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-warning">
                                <i class="ri-hourglass-fill"></i>
                              </span>
                              <small><?php echo e(translate("Pending")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs['sms']['pending'])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-danger">
                                <i class="ri-mail-close-line"></i>
                              </span>
                              <small><?php echo e(translate("Failed")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["sms"]["failed"])); ?></p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-xxl-4 col-xl-4">
                  <div class="card feature-card">
                    <div class="card-header pb-0">
                      <div class="card-header-left">
                        <h4 class="card-title"><?php echo e(translate("Email Statistics")); ?></h4>
                      </div>
                      <div class="card-header-right">
                        <span class="fs-3 text-danger">
                          <i class="ri-mail-line"></i>
                        </span>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="row g-3">
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-primary">
                                <i class="ri-mail-line"></i>
                              </span>
                              <small><?php echo e(translate("Total")); ?></small>
                            </div>
                            
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["email"]["all"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-success">
                                <i class="ri-mail-check-line"></i>
                              </span>
                              <small><?php echo e(translate("Success")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["email"]["success"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-warning">
                                <i class="ri-hourglass-fill"></i>
                              </span>
                              <small><?php echo e(translate("Pending")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["email"]["pending"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-danger">
                                <i class="ri-mail-close-line"></i>
                              </span>
                              <small><?php echo e(translate("Failed")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["email"]["failed"])); ?></p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-xxl-4 col-xl-4">
                  <div class="card feature-card">
                    <div class="card-header pb-0">
                      <div class="card-header-left">
                        <h4 class="card-title"><?php echo e(translate("Whatsapp Statistics")); ?></h4>
                      </div>
                      <div class="card-header-right">
                        <span class="fs-3 text-success">
                          <i class="ri-whatsapp-line"></i>
                        </span>
                      </div>
                    </div>
                    <div class="card-body">
                      <div class="row g-3">
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-primary">
                                <i class="ri-whatsapp-line"></i>
                              </span>
                              <small><?php echo e(translate("Total")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["whats_app"]["all"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-success">
                                <i class="ri-mail-check-line"></i>
                              </span>
                              <small><?php echo e(translate("Success")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["whats_app"]["success"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-warning">
                                <i class="ri-hourglass-fill"></i>
                              </span>
                              <small><?php echo e(translate("Pending")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["whats_app"]["pending"])); ?></p>
                          </div>
                        </div>
                        <div class="col-6">
                          <div class="feature-status">
                            <div class="feature-status-left">
                              <span class="feature-icon text-danger">
                                <i class="ri-mail-close-line"></i>
                              </span>
                              <small><?php echo e(translate("Failed")); ?></small>
                            </div>
                            <p class="feature-status-count"><?php echo e(formatNumber($logs["whats_app"]["failed"])); ?></p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xxl-2">
              <div class="membership-card card-height-100">
                <div class="membership-content">
                  <h5><?php echo e(translate("WhatsApp Cloud API")); ?></h5>
                  <p> <?php echo e(translate("As an alternative solution to the WhatsApp Node Modules, you can try out our cloud api system")); ?> </p>
                </div>
                <a href="#" class="membership-btn"><?php echo e(translate("Try now")); ?></a>
                <span class="membership-shape">
                  <svg xmlns="http://www.w3.org/2000/svg" width="101" height="110" viewBox="0 0 101 110" fill="none">
                    <circle cx="99.6525" cy="127.091" r="42.5448" transform="rotate(-64.4926 99.6525 127.091)" fill="<?php echo e(site_settings('trinary_color')); ?>" fill-opacity="0.4" />
                    <circle cx="92.0618" cy="89.32" r="67" transform="rotate(-64.4926 92.0618 89.32)" fill="<?php echo e(site_settings('trinary_color')); ?>" fill-opacity="0.4" />
                  </svg>
                </span>
              </div>
            </div>
          </div>
        </div>

       
        <div class="col-xxl-6">
          <div class="card">
            <div class="card-header">
              <div class="card-header-left">
                <h4 class="card-title"><?php echo e(translate("Latest Credit Log")); ?></h4>
              </div>
            </div>
            <div class="card-body px-0 pt-0">
              <div class="table-container">
                <div class="default_table">
                  <table>
                    <thead>
                        <tr>
                            <th><?php echo e(translate('Date')); ?></th>
                            <th><?php echo e(translate('Trx Number')); ?></th>
                            <th><?php echo e(translate('Credit')); ?></th>
                            <th><?php echo e(translate('Previous Credit')); ?></th>
                        </tr>
                    </thead>
                    <?php $__empty_1 = true; $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php if($loop->even): ?><?php endif; ?>">
                            <td data-label="<?php echo e(translate('Date')); ?>">
                                <span><?php echo e(diffForHumans($credit_data->created_at)); ?></span><br>
                                <?php echo e(getDateTime($credit_data->created_at)); ?>

                            </td>

                            <td data-label="<?php echo e(translate('Trx Number')); ?>">
                                <?php echo e($credit_data->trx_number); ?>

                            </td>

                            <td data-label="<?php echo e(translate('Credit')); ?>">
                                <span class="i-badge <?php echo e($credit_data->type == \App\Enums\ServiceType::SMS->value ? 'info-soft' : ($credit_data->type == \App\Enums\ServiceType::WHATSAPP->value ? 'success-soft' : 'warning-soft')); ?>"><?php echo e($credit_data->credit_type == \App\Enums\StatusEnum::TRUE->status() ? '+' : '-'); ?> <?php echo e(shortAmount($credit_data->credit).' '.ucfirst(strtolower(\App\Enums\ServiceType::getValue($credit_data->type)))); ?><?php echo e(translate(' Credit')); ?>

                                </span>
                            </td>

                            <td data-label="<?php echo e(translate('Previous Credit')); ?>">
                                <?php echo e($credit_data->post_credit); ?> <?php echo e(translate('Credit')); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e(translate('No Data Found')); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xxl-6">
          <div class="card">
            <div class="card-header">
              <div class="card-header-left">
                <h4 class="card-title"><?php echo e(translate("Latest Transactions Log")); ?></h4>
              </div>
            </div>
            <div class="card-body px-0 pt-0">
              <div class="table-container">
                <div class="default_table">
                  <table>
                    <thead>
                        <tr>
                            <th><?php echo e(translate('Date')); ?></th>
                            <th><?php echo e(translate('Trx Number')); ?></th>
                            <th><?php echo e(translate('Amount')); ?></th>
                            <th><?php echo e(translate('Detail')); ?></th>
                        </tr>
                    </thead>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php if($loop->even): ?><?php endif; ?>">
                            <td data-label="<?php echo e(translate('Date')); ?>">
                                <span><?php echo e(diffForHumans($transaction->created_at)); ?></span><br>
                                <?php echo e(getDateTime($transaction->created_at)); ?>

                            </td>

                            <td data-label="<?php echo e(translate('Trx Number')); ?>">
                                <?php echo e($transaction->transaction_number); ?>

                            </td>

                            <td data-label="<?php echo e(translate('Amount')); ?>">
                                <span class="i-badge <?php if($transaction->transaction_type == '+'): ?>success-soft <?php else: ?> danger-soft <?php endif; ?>"><?php echo e($transaction->transaction_type); ?> <?php echo e(shortAmount($transaction->amount)); ?> 
                                </span>
                            </td>

                            <td data-label="<?php echo e(translate('Details')); ?>">
                                <?php echo e($transaction->details); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e(translate('No Data Found')); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("user.layouts.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/user/dashboard.blade.php ENDPATH**/ ?>