<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>
    <main class="main-body">
        <div class="container-fluid px-0 main-content">
            <div class="page-header">
                <div class="page-header-left">
                    <h2><?php echo e($title); ?></h2>
                    <div class="breadcrumb-wrapper">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="table-filter mb-4">
                <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
                    
                    <div class="row g-3">
                        <div class="col-xxl-3 col-lg-3">
                            <div class="filter-search">
                                <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Filter by name or email")); ?>" />
                                <span><i class="ri-search-line"></i></span>
                            </div>
                        </div>
                        <div class="col-xxl-8 col-lg-9 offset-xxl-1">
                            <div class="filter-action">
                                <select data-placeholder="<?php echo e(translate('Select A Verification Status')); ?>" class="form-select select2-search" name="email_verified_status" aria-label="Default select example">
                                    <option value=""></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Verified")); ?></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Unverified")); ?></option>
                                </select>

                                <div class="input-group">
                                    <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                                    <span class="input-group-text" id="filterByDate">
                                        <i class="ri-calendar-2-line"></i>
                                    </span>
                                </div>

                                <button type="submit" class="filter-action-btn ">
                                    <i class="ri-menu-search-line"></i> <?php echo e(translate("Filter")); ?>

                                </button>
                                <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                    <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card">
                <div class="card-header">
                    <div class="card-header-left">
                        <h4 class="card-title"><?php echo e(translate("User List")); ?></h4>
                    </div>
                    <div class="card-header-right">
                        <button class="i-btn btn--primary btn--sm add-user" type="button" data-bs-toggle="modal" data-bs-target="#addUser">
                            <i class="ri-add-fill fs-16"></i> <?php echo e(translate("Add User")); ?>

                        </button>
                    </div>
                </div>
                <div class="card-body px-0 pt-0">
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th scope="col"><?php echo e(translate("Customer")); ?></th>
                                    <th scope="col"><?php echo e(translate("Joined")); ?></th>
                                    <th scope="col"><?php echo e(translate("Status")); ?></th>
                                    <th scope="col"><?php echo e(translate("Option")); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                           <div class="d-flex align-items-center gap-2 ">
                                                <span class="user-logo flex-shrink-0">
                                                    <img src="<?php echo e(showImage(filePath()['profile']['user']['path'].'/'.$customer->image, filePath()['profile']['user']['size'])); ?>" alt="<?php echo e($customer->username); ?>">
                                                </span>
                                                <div class="lh-1">
                                                    <p class="text-dark fs-14 fw-semibold mb-1"><?php echo e($customer->name); ?></p>
                                                    <a class="text-primary fs-12" ><?php echo e($customer->email); ?></a>
                                                </div>
                                           </div>
                                           
                                        </td>
                                        <td>
                                            <span><?php echo e($customer?->created_at->diffForHumans()); ?></span>
                                            <p> <?php echo e($customer?->created_at->toDayDateTimeString()); ?></p>
                                        </td>
                                        <td>
                                            <span class="i-badge dot <?php echo e($customer->status == \App\Enums\StatusEnum::TRUE->status() ? 'success' : 'danger'); ?>-soft pill"><?php echo e($customer->status == \App\Enums\StatusEnum::TRUE->status() ? 'Active' : 'Banned'); ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-1">
                                               
                                                <a class="icon-btn btn-ghost btn-sm dark-soft circle modify-credits"
                                                    type="button"
                                                    data-uid = "<?php echo e($customer->uid); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#modifyCredit">
                                                    <i class="ri-hand-coin-line"></i>
                                                    <span class="tooltiptext"> <?php echo e(translate("Add/Deduct Credits")); ?> </span>
                                                </a>
                                                <a href="<?php echo e(route('admin.user.details', $customer->id)); ?>" target="_blank" class="icon-btn btn-ghost btn-sm info-soft circle text-danger">
                                                    
                                                    <i class="ri-profile-line"></i>
                                                    <span class="tooltiptext"> <?php echo e(translate("View: ").$customer->name.translate(" profile")); ?> </span>
                                                </a>
                                                <a href="<?php echo e(route('admin.user.login', $customer->uid)); ?>" target="_blank" class="icon-btn btn-ghost btn-sm success-soft circle">
                                                    <i class="ri-logout-box-r-line"></i>
                                                    <span class="tooltiptext"> <?php echo e(translate("Login as: ").$customer->name); ?> </span>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="pagination-wrapper px-4 pt-3">
                        <p class="pagination-summary">
                            <?php if($customers->appends(request()->all())): ?>
                                <?php echo e(translate("Showing")); ?> <?php echo e($customers->appends(request()->all())->firstItem()); ?>-<?php echo e($customers->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($customers->appends(request()->all())->total()); ?>

                            <?php endif; ?>
                        </p>
                        <nav aria-label="...">
                            <?php if($customers->appends(request()->all())->hasPages()): ?>
                            <nav aria-label="...">
                                <ul class="pagination">
                                    <?php if($customers->appends(request()->all())->onFirstPage()): ?>
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($customers->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    
                                    <?php $__currentLoopData = $customers->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php if(is_array($element)): ?>
                                            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php
                                                    if(request()->input("date")) {
                                                        $query_step = 4;
                                                    }
                                                    elseif(request()->input("search")) {
                                                        $query_step = 3;
                                                    } elseif(request()->_token) {
                                                        $query_step = 2;
                                                    } else{
                                                        $query_step = 1;
                                                    }

                                                    $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                                ?>
                                                <?php if($page == $customers->appends(request()->all())->currentPage()): ?>

                                                    <li class="page-item active" aria-current="page">
                                                        <span class="page-link"><?php echo e($page); ?></span>
                                                    </li>
                                                <?php else: ?>

                                                    <li class="page-item">
                                                        <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <li class="page-item" aria-current="page">
                                                <span class="page-link"><?php echo e("..."); ?></span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    
                                    <?php if($customers->appends(request()->all())->hasMorePages()): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($customers->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                            <?php endif; ?>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="addUser" tabindex="-1" aria-labelledby="addUser" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.user.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Add New User")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="name" class="form-label"> <?php echo e(translate('Name')); ?><span class="text-danger">*</span> </label>
                                <input type="text" id="name" name="name" placeholder="<?php echo e(translate('Enter user\'s name')); ?>" class="form-control" aria-label="name"/>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="email" class="form-label"> <?php echo e(translate('Email Address')); ?><span class="text-danger">*</span> </label>
                                <input type="text" id="email" name="email" placeholder="<?php echo e(translate('Enter user\'s Email address')); ?>" class="form-control" aria-label="email"/>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="password" class="form-label"> <?php echo e(translate('User Password')); ?><span class="text-danger">*</span> </label>
                                <input type="password" id="password" name="password" class="form-control" aria-label="password" placeholder="<?php echo e(translate('Enter a password for this user')); ?>"/>
                                <p class="form-element-note text-danger"><?php echo e(translate("User will use this password for login")); ?></p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <div class="form-inner">
                                    <label for="password_confirmation" class="form-label"> <?php echo e(translate('Confirm Password')); ?><span class="text-danger">*</span> </label>
                                    <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" aria-label="password_confirmation" placeholder="<?php echo e(translate('Confirm the password')); ?>"/>
                                    <p class="form-element-note text-danger"><?php echo e(translate("Please re-type the password for confirmation")); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="modifyCredit" tabindex="-1" aria-labelledby="modifyCredit" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.user.modify.credit')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="uid" value="">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Modify User's Credits")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="form-inner">
                                <label for="type" class="form-label"><?php echo e(translate("Select Credit Modification Type")); ?><span class="text-danger">*</span></label>
                                <select data-placeholder="<?php echo e(translate('Select a modification type')); ?>" class="form-select select2-search" data-show="5" id="type" name="type">
                                    <option value=""></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Add Credits")); ?></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Deduct Credits")); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="sms_credit" class="form-label"> <?php echo e(translate("User's SMS Credit")); ?><span class="text-danger">*</span> </label>
                                <input type="text" id="sms_credit" name="sms_credit" placeholder="<?php echo e(translate('Enter sms credit amount')); ?>" class="form-control" aria-label="sms_credit"/>

                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="email_credit" class="form-label"><?php echo e(translate("User's Email Credit")); ?><span class="text-danger">*</span> </label>
                                <input type="text" id="email_credit" name="email_credit" placeholder="<?php echo e(translate('Enter email credit amount')); ?>" class="form-control" aria-label="email_credit"/>

                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-inner">
                                <label for="whatsapp_credit" class="form-label"> <?php echo e(translate("User's WhatsApp Credit")); ?><span class="text-danger">*</span> </label>
                                <input type="text" id="whatsapp_credit" name="whatsapp_credit" placeholder="<?php echo e(translate('Enter whatsapp credit amount')); ?>" class="form-control" aria-label="whatsapp_credit"/>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        (function($){
            "use strict";
            select2_search($('.select2-search').data('placeholder'));
            $('.add-user').on('click', function() {
                const modal = $('#addUser');
			    modal.modal('show');
            });
            $('.modify-credits').on('click', function(){
                var modal = $('#modifyCredit');
                modal.find('input[name=uid]').val($(this).data('uid'));
                modal.modal('show');
            });

            flatpickr("#datePicker", {
                dateFormat: "Y-m-d",
                mode: "range",
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/customer/index.blade.php ENDPATH**/ ?>