<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?> 

<?php $__env->startSection("panel"); ?>
  <main class="main-body">
    <div class="container-fluid px-0 main-content">
      <div class="page-header">
        <div class="page-header-left">
          <h2><?php echo e($title); ?></h2>
          <div class="breadcrumb-wrapper">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item">
                  <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
      <div class="pill-tab mb-4">
        <ul class="nav" role="tablist">
         
          <li class="nav-item" role="presentation">
            <a class="nav-link active" data-bs-toggle="tab" href="#authentication" role="tab" aria-selected="true">
              <i class="ri-notification-2-line"></i> 
              <?php echo e(translate("Authentication Settings")); ?> 
            </a>
          </li>

          <li class="nav-item" role="presentation">
            <a class="nav-link" data-bs-toggle="tab" href="#onboarding" role="tab" aria-selected="false" tabindex="-1">
              <i class="ri-android-line"></i> 
              <?php echo e(translate("Onboarding Settings")); ?> 
            </a>
          </li>
        </ul>
      </div>
      <div class="tab-content">
        <div class="tab-pane active fade show" id="authentication" role="tabpanel">
            <div class="card">
                <div class="form-header">
                <h4 class="card-title"><?php echo e(translate("Authentication Settings")); ?></h4>
                </div>
                <div class="card-body pt-0">
                    <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-element">
                            <div class="row gy-4">
                                <div class="col-xxl-2 col-xl-3">
                                <h5 class="form-element-title"><?php echo e(translate("Authentication")); ?></h5>
                                </div>
                                <div class="col-xxl-8 col-xl-9">
                                    <div class="row gy-4">
                                        <?php $__currentLoopData = json_decode(site_settings("member_authentication"), true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $auth_key => $auth_param): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <div class="col-md-6">
                                                <?php if($auth_key == "login_with"): ?>
                                                    <div class="form-inner">
                                                        <label for="login_with" class="form-label"><?php echo e(translate("Login With")); ?></label>
                                                        <select data-placeholder="<?php echo e(translate("Choose member login parameters")); ?>" class="form-select select2-search" name="site_settings[member_authentication][<?php echo e($auth_key); ?>][]" data-show="5" id="login_with" multiple="multiple">
                                                            <option value=""></option>
                                                            <?php $__currentLoopData = config('setting.login_attribute'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $auth): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php if(in_array($auth , json_decode(site_settings("member_authentication"), true)['login_with'] ?? [] )): ?> selected <?php endif; ?>   value="<?php echo e($auth); ?>"><?php echo e($auth); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="form-inner">
                                                        <label class="form-label"> <?php echo e(translate("Member ".textFormat(['_'], $auth_key, ' '))); ?> </label>
                                                        <div class="form-inner-switch">
                                                            <label class="pointer" for="member_authentication_<?php echo e($auth_key); ?>"><?php echo e(translate("Turn on/off Member ".textFormat(['_'], $auth_key, ' '))); ?></label>
                                                            <div class="switch-wrapper mb-1 checkbox-data">
                                                                <input <?php echo e($auth_param == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>" type="checkbox" class="switch-input" id="member_authentication_<?php echo e($auth_key); ?>" name="site_settings[member_authentication][<?php echo e($auth_key); ?>]"/>
                                                                <label for="member_authentication_<?php echo e($auth_key); ?>" class="toggle">
                                                                <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-element">
                            <div class="row gy-4">
                                <div class="col-xxl-2 col-xl-3">
                                <h5 class="form-element-title"><?php echo e(translate("Verification Code")); ?></h5>
                                </div>
                                <div class="col-xxl-8 col-xl-9">
                                <div class="row gy-4">
                                    <div class="col-md-12 parent">
                                        <div class="form-inner">
                                            <label class="form-label"> <?php echo e(translate("OTP Verification")); ?> </label>
                                            <div class="form-inner-switch">
                                            <label class="pointer" for="registration_otp_verification"><?php echo e(translate("Turn on/off otp verification")); ?></label>
                                            <div class="switch-wrapper mb-1 checkbox-data">
                                                <input <?php echo e(site_settings("registration_otp_verification") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="registration_otp_verification" name="site_settings[registration_otp_verification]"/>
                                                <label for="registration_otp_verification" class="toggle">
                                                <span></span>
                                                </label>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 child">
                                        <div class="form-inner">
                                            <label class="form-label"> <?php echo e(translate("Email OTP Verification")); ?> </label>
                                            <div class="form-inner-switch">
                                            <label class="pointer" for="email_otp_verification"><?php echo e(translate("Turn on/off Email otp verification")); ?></label>
                                            <div class="switch-wrapper mb-1 checkbox-data">
                                                <input <?php echo e(site_settings("email_otp_verification") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="email_otp_verification" name="site_settings[email_otp_verification]"/>
                                                <label for="email_otp_verification" class="toggle">
                                                <span></span>
                                                </label>
                                            </div>
                                            </div>
                                            <p class="form-element-note text-danger"><?php echo e(translate("Requires a Default Email Gateway.")); ?> <a href="<?php echo e(route('admin.gateway.email.index')); ?>"><?php echo e(translate("Set up gateway")); ?></a> </p>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="row">
                            <div class="col-xxl-10">
                                <div class="form-action justify-content-end">
                                    <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="onboarding" role="tabpanel">
            <div class="card">
                <div class="form-header">
                <h4 class="card-title"><?php echo e(translate("Onboarding Settings")); ?></h4>
                </div>
                <div class="card-body pt-0">
                    <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-element">
                            <div class="row gy-4">
                                <div class="col-xxl-2 col-xl-3">
                                    <h5 class="form-element-title"><?php echo e(translate("Rewards")); ?></h5>
                                    </div>
                                    <div class="col-xxl-8 col-xl-9">
                                    <div class="row gy-4">
                                        <div class="col-md-12">
                                            <div class="form-inner">
                                                <label class="form-label"> <?php echo e(translate("Onboarding Bonus")); ?> </label>
                                                <div class="form-inner-switch parent">
                                                <label class="pointer" for="onboarding_bonus"><?php echo e(translate("Turn on/off onboarding registration")); ?></label>
                                                <div class="switch-wrapper mb-1">
                                                    <input <?php echo e(site_settings("onboarding_bonus") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="onboarding_bonus" name="site_settings[onboarding_bonus]"/>
                                                    <label for="onboarding_bonus" class="toggle">
                                                    <span></span>
                                                    </label>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-inner child">
                                                <label for="onboarding_bonus_plan" class="form-label"><?php echo e(translate("Onboarding Reward Plan")); ?></label>
                                                <select data-placeholder="<?php echo e(translate('Select a plan')); ?>" class="form-select select2-search" name="site_settings[onboarding_bonus_plan]" data-show="5" id="onboarding_bonus_plan">
                                                    <option value=""></option>
                                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php echo e(site_settings("onboarding_bonus_plan") == $plan->id ? 'selected' : ''); ?> value="<?php echo e($plan->id); ?>"><?php echo e($plan->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xxl-10">
                                <div class="form-action justify-content-end">
                                <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                                <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>  
<?php $__env->stopPush(); ?>
<?php $__env->startPush("script-push"); ?>

  <script>
    "use strict";
    $(document).ready(function() {
       
        select2_search($("#onboarding_bonus_plan").attr("data-placeholder"));
        setInitialVisibility();
        updateBackgroundClass();
        $('.parent input[type="checkbox"]').change(function() {

            toggleChildren();
        });

        $('.switch-input').on('change', function() {

            updateBackgroundClass();
        });
        $('form').on('submit', function(e) {
            
            $('.checkbox-data').each(function() {
                var $checkbox = $(this).find('.switch-input');
                var $hiddenInput = $(this).find('input[type="hidden"]');

                if ($checkbox.is(':checked')) {
                    if ($hiddenInput.length === 0) {
                        $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>">');
                    } else {
                        $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>');
                    }
                } else {
                    if ($hiddenInput.length === 0) {
                        $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>">');
                    } else {
                        $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>');
                    }
                }
            });
      });
    });
    
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/setting/member.blade.php ENDPATH**/ ?>