@extends('user.layouts.app')
@section('panel')

<main class="main-body">
    <div class="container-fluid px-0 main-content">
      <div class="page-header">
        <div class="row gy-4">
          <div class="col-md-5">
            <div class="page-header-left">
              <h2>{{ $title }}</h2>
              <div class="breadcrumb-wrapper">
                <nav aria-label="breadcrumb">
                  <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                      <a href="{{ route('user.dashboard') }}">{{ translate("Dashboard") }}</a>
                    </li>
                    <li class="breadcrumb-item">
                      <a href="{{ route('user.plan.create') }}">{{ translate("Plans") }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"> {{ translate("Make Payment") }} </li>
                  </ol>
                </nav>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row justify-content-center">

        <div class="col-lg-8">
          <div class="card">
            <div class="card-header">
              <h4 class="card-title">{{ translate("Choose A Payment Gateway") }}</h4>
            </div>
            <div class="card-body p-4">
              <div class="step-wrapper step-full-width justify-content-start">
                <ul class="progress-steps">
                  <li class="step-item activated active">
                    <span>{{ translate("01") }}</span> {{ translate("Gateway") }}
                  </li>
                  <li class="step-item manual">
                    <span>{{ translate("02") }}</span> {{ translate("Details") }}
                  </li>
                  <li class="step-item">
                    <span>{{ translate("03") }}</span> {{ translate("Pay now") }}
                  </li>
                </ul>
              </div>
              <div class="step-content">
                <div class="step-content-item active">
                  <div class="pill-tab mb-5">
                    <ul class="nav" role="tablist">
                      <li class="nav-item" role="presentation">
                        <a class="nav-link active" data-bs-toggle="tab" href="#automaticPayment" role="tab" aria-selected="true">
                          <i class="ri-user-settings-line"></i> {{ translate("Automatic Payment") }} </a>
                      </li>
                      <li class="nav-item" role="presentation">
                        <a class="nav-link" data-bs-toggle="tab" href="#manualPayment" role="tab" aria-selected="false" tabindex="-1">
                          <i class="ri-user-line"></i>{{ translate("Manual Payment") }} </a>
                      </li>
                    </ul>
                  </div>
                  <div class="tab-content">
                    <div class="tab-pane active fade show" id="automaticPayment" role="tabpanel">
                      <div class="gateways">
                        <ul class="gateway-list">
                            @foreach($payment_methods as $payment_method)
                                @if(strpos($payment_method->unique_code, 'MANUAL') === false)
                                    <li class="gateway-item">
                                        <div class="form-check card-radio" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="{{ $payment_method->name }}">
                                        <input id="automatic-{{$payment_method->id}}" type="radio" class="form-check-input" name="payment_gateway" />
                                        <label class="form-check-label w-100 text-center" for="automatic-{{$payment_method->id}}">
                                            <span class="gateway-img">
                                                <img src="{{showImage(config('setting.file_path.automatic_payment.path').'/'.$payment_method->image, config('setting.file_path.automatic_payment.size'))}}" class="automatic-payment-logo">
                                            </span>
                                        </label>
                                        </div>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                      </div>
                    </div>
                    <div class="tab-pane fade" id="manualPayment" role="tabpanel">
                      <div class="gateways">
                        <ul class="gateway-list">
                            @foreach($payment_methods as $payment_method)
                                @if(strpos($payment_method->unique_code, 'MANUAL') !== false)
                                    <li class="gateway-item">
                                        <div class="form-check card-radio" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="{{ $payment_method->name }}">
                                        <input id="manual-{{$payment_method->id}}" type="radio" class="form-check-input" name="payment_gateway" />
                                        <label class="form-check-label w-100 text-center" for="manual-{{$payment_method->id}}">
                                            <span class="gateway-img">
                                                <img src="{{showImage(config('setting.file_path.manual_payment.path').'/'.$payment_method->image, config('setting.file_path.manual_payment.size'))}}" class="manual-payment-logo">
                                            </span>
                                        </label>
                                        </div>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                      </div>
                    </div>
                  </div>
                  <div class="form-action justify-content-between">
                    <button type="button" class="i-btn btn--dark outline btn--md step-back-btn"> {{ translate("Previous") }} </button>
                    <button type="button" class="i-btn btn--primary btn--md register-payment-log step-next-btn payment-gateway-selection-next d-none"> {{ translate("Next") }} </button>
                  </div>
                </div>
                <div class="step-content-item">
                  <div class="payment-details">
                    @php
                        $symbol = getDefaultCurrencySymbol(json_decode(site_settings("currencies"), true));
                    @endphp
                    <ul class="list-group list-group-flush">
                      <li class="list-group-item plan-name">{{ translate("Membership Plan Name") }} <span></span>
                      </li>
                      <li class="list-group-item payment-method-name">{{ translate("Selected Gateway Name") }} <span></span>
                      </li>
                      <li class="list-group-item payment-log-amount">{{ translate("Amount") }} <span></span>
                      </li>
                      <li class="list-group-item payment-log-charge">{{ translate("Charge") }} <span></span>
                      </li>
                      <li class="list-group-item payment-log-total"> {{ translate("Payable") }} <span></span>
                      </li>
                      <li class="list-group-item payment-final-amount">{{ translate("Final USD") }} <span></span>
                      </li>
                    </ul>
                  </div>
                  <div class="form-action justify-content-between">
                    <button type="button" class="i-btn btn--dark outline btn--md step-back-btn"> {{ translate("Previous") }}  </button>
                    <button type="button" class="i-btn btn--primary btn--md step-next-btn"> {{ translate("Next") }} </button>
                  </div>
                </div>
                <div class="step-content-item">
                  <div class="add-manual-fields">
                  </div>
                  <div class="automatic-field">
                    <div class="pament-svg">
                      <svg
                        xmlns="http://www.w3.org/2000/svg"
                        
                        viewBox="0 0 4301 3283"
                        fill="none"
                      >
                        <path
                          d="M1225.29 1747.28H2298.39C2318.41 1747.28 2334.69 1731 2334.69 1710.98V1032.3C2334.69 1012.28 2318.41 996 2298.39 996H1225.29C1205.28 996 1189 1012.28 1189 1032.3V1710.98C1189 1731 1205.28 1747.28 1225.29 1747.28ZM1201.61 1032.29C1201.61 1019.22 1212.24 1008.6 1225.29 1008.6H2298.39C2311.46 1008.6 2322.08 1019.23 2322.08 1032.29V1710.97C2322.08 1724.04 2311.45 1734.66 2298.39 1734.66H1225.29C1212.24 1734.66 1201.61 1724.03 1201.61 1710.97V1032.29Z"
                          fill="inherit"
                        />
                        <path
                          d="M2049.19 725.1H1474.28C1470.79 725.1 1467.97 727.92 1467.97 731.41C1467.97 734.9 1470.79 737.72 1474.28 737.72H2049.19C2052.67 737.72 2055.49 734.9 2055.49 731.41C2055.49 727.92 2052.67 725.1 2049.19 725.1Z"
                          fill="inherit"
                        />
                        <path
                          d="M2053.59 577.66H1967.39C1963.9 577.66 1961.08 580.48 1961.08 583.97C1961.08 587.46 1963.9 590.28 1967.39 590.28H2053.59C2057.07 590.28 2059.89 587.46 2059.89 583.97C2059.89 580.48 2057.07 577.66 2053.59 577.66Z"
                          fill="inherit"
                        />
                        <path
                          d="M1474.95 590.27H1844.63C1848.11 590.27 1850.93 587.45 1850.93 583.96C1850.93 580.47 1848.11 577.65 1844.63 577.65H1474.95C1471.46 577.65 1468.64 580.47 1468.64 583.96C1468.64 587.45 1471.46 590.27 1474.95 590.27Z"
                          fill="inherit"
                        />
                        <path
                          d="M1924.61 442.83H2054.26C2057.74 442.83 2060.57 440.01 2060.57 436.53C2060.57 433.05 2057.75 430.22 2054.26 430.22H1924.61C1921.13 430.22 1918.31 433.04 1918.31 436.53C1918.31 440.02 1921.13 442.83 1924.61 442.83Z"
                          fill="inherit"
                        />
                        <path
                          d="M1475.61 442.83H1845.28C1848.76 442.83 1851.59 440.01 1851.59 436.53C1851.59 433.05 1848.77 430.22 1845.28 430.22H1475.61C1472.12 430.22 1469.3 433.04 1469.3 436.53C1469.3 440.02 1472.12 442.83 1475.61 442.83Z"
                          fill="inherit"
                        />
                        <path
                          d="M2054.92 282.77H1981.62C1978.14 282.77 1975.31 285.59 1975.31 289.08C1975.31 292.57 1978.13 295.39 1981.62 295.39H2054.92C2058.4 295.39 2061.23 292.57 2061.23 289.08C2061.23 285.59 2058.41 282.77 2054.92 282.77Z"
                          fill="inherit"
                        />
                        <path
                          d="M1476.27 295.38H1845.95C1849.43 295.38 1852.26 292.56 1852.26 289.07C1852.26 285.58 1849.44 282.76 1845.95 282.76H1476.27C1472.79 282.76 1469.97 285.58 1469.97 289.07C1469.97 292.56 1472.79 295.38 1476.27 295.38Z"
                          fill="inherit"
                        />
                        <path
                          d="M1963.77 147.94H2055.59C2059.07 147.94 2061.9 145.12 2061.9 141.63C2061.9 138.14 2059.08 135.32 2055.59 135.32H1963.77C1960.28 135.32 1957.46 138.14 1957.46 141.63C1957.46 145.12 1960.28 147.94 1963.77 147.94Z"
                          fill="inherit"
                        />
                        <path
                          d="M1467.88 147.94H1846.61C1850.09 147.94 1852.92 145.12 1852.92 141.63C1852.92 138.14 1850.1 135.32 1846.61 135.32H1467.88C1464.4 135.32 1461.57 138.14 1461.57 141.63C1461.57 145.12 1464.39 147.94 1467.88 147.94Z"
                          fill="inherit"
                        />
                        <path
                          d="M1438.36 1857.33H1209.85C1198.64 1857.33 1189.52 1866.44 1189.52 1877.65V1994.81C1189.52 2006.02 1198.64 2015.14 1209.85 2015.14H1438.36C1449.57 2015.14 1458.68 2006.02 1458.68 1994.81V1877.65C1458.68 1866.44 1449.57 1857.33 1438.36 1857.33ZM1446.07 1994.81C1446.07 1999.07 1442.61 2002.53 1438.36 2002.53H1209.85C1205.59 2002.53 1202.13 1999.07 1202.13 1994.81V1877.65C1202.13 1873.4 1205.59 1869.94 1209.85 1869.94H1438.36C1442.61 1869.94 1446.07 1873.4 1446.07 1877.65V1994.81Z"
                          fill="inherit"
                        />
                        <path
                          d="M1876.53 1857.33H1648.01C1636.8 1857.33 1627.69 1866.44 1627.69 1877.65V1994.81C1627.69 2006.02 1636.8 2015.14 1648.01 2015.14H1876.53C1887.74 2015.14 1896.85 2006.02 1896.85 1994.81V1877.65C1896.85 1866.44 1887.74 1857.33 1876.53 1857.33ZM1884.24 1994.81C1884.24 1999.07 1880.78 2002.53 1876.53 2002.53H1648.01C1643.76 2002.53 1640.3 1999.07 1640.3 1994.81V1877.65C1640.3 1873.4 1643.76 1869.94 1648.01 1869.94H1876.53C1880.78 1869.94 1884.24 1873.4 1884.24 1877.65V1994.81Z"
                          fill="inherit"
                        />
                        <path
                          d="M2314.69 1857.33H2086.18C2074.97 1857.33 2065.86 1866.44 2065.86 1877.65V1994.81C2065.86 2006.02 2074.97 2015.14 2086.18 2015.14H2314.69C2325.9 2015.14 2335.02 2006.02 2335.02 1994.81V1877.65C2335.02 1866.44 2325.9 1857.33 2314.69 1857.33ZM2322.41 1994.81C2322.41 1999.07 2318.95 2002.53 2314.69 2002.53H2086.18C2081.93 2002.53 2078.47 1999.07 2078.47 1994.81V1877.65C2078.47 1873.4 2081.93 1869.94 2086.18 1869.94H2314.69C2318.95 1869.94 2322.41 1873.4 2322.41 1877.65V1994.81Z"
                          fill="inherit"
                        />
                        <path
                          d="M1438.36 2124.56H1209.85C1198.64 2124.56 1189.52 2133.68 1189.52 2144.89V2262.05C1189.52 2273.26 1198.64 2282.37 1209.85 2282.37H1438.36C1449.57 2282.37 1458.68 2273.26 1458.68 2262.05V2144.89C1458.68 2133.68 1449.57 2124.56 1438.36 2124.56ZM1446.07 2262.05C1446.07 2266.3 1442.61 2269.76 1438.36 2269.76H1209.85C1205.59 2269.76 1202.13 2266.3 1202.13 2262.05V2144.89C1202.13 2140.63 1205.59 2137.17 1209.85 2137.17H1438.36C1442.61 2137.17 1446.07 2140.63 1446.07 2144.89V2262.05Z"
                          fill="inherit"
                        />
                        <path
                          d="M1876.53 2124.56H1648.01C1636.8 2124.56 1627.69 2133.68 1627.69 2144.89V2262.05C1627.69 2273.26 1636.8 2282.37 1648.01 2282.37H1876.53C1887.74 2282.37 1896.85 2273.26 1896.85 2262.05V2144.89C1896.85 2133.68 1887.74 2124.56 1876.53 2124.56ZM1884.24 2262.05C1884.24 2266.3 1880.78 2269.76 1876.53 2269.76H1648.01C1643.76 2269.76 1640.3 2266.3 1640.3 2262.05V2144.89C1640.3 2140.63 1643.76 2137.17 1648.01 2137.17H1876.53C1880.78 2137.17 1884.24 2140.63 1884.24 2144.89V2262.05Z"
                          fill="inherit"
                        />
                        <path
                          d="M2314.69 2124.56H2086.18C2074.97 2124.56 2065.86 2133.68 2065.86 2144.89V2262.05C2065.86 2273.26 2074.97 2282.37 2086.18 2282.37H2314.69C2325.9 2282.37 2335.02 2273.26 2335.02 2262.05V2144.89C2335.02 2133.68 2325.9 2124.56 2314.69 2124.56ZM2322.41 2262.05C2322.41 2266.3 2318.95 2269.76 2314.69 2269.76H2086.18C2081.93 2269.76 2078.47 2266.3 2078.47 2262.05V2144.89C2078.47 2140.63 2081.93 2137.17 2086.18 2137.17H2314.69C2318.95 2137.17 2322.41 2140.63 2322.41 2144.89V2262.05Z"
                          fill="inherit"
                        />
                        <path
                          d="M1438.36 2391.81H1209.85C1198.64 2391.81 1189.52 2400.92 1189.52 2412.13V2529.29C1189.52 2540.5 1198.64 2549.62 1209.85 2549.62H1438.36C1449.57 2549.62 1458.68 2540.5 1458.68 2529.29V2412.13C1458.68 2400.92 1449.57 2391.81 1438.36 2391.81Z"
                          fill="inherit"
                        />
                        <path
                          d="M1876.53 2391.81H1648.01C1636.8 2391.81 1627.69 2400.92 1627.69 2412.13V2529.29C1627.69 2540.5 1636.8 2549.62 1648.01 2549.62H1876.53C1887.74 2549.62 1896.85 2540.5 1896.85 2529.29V2412.13C1896.85 2400.92 1887.74 2391.81 1876.53 2391.81ZM1884.24 2529.29C1884.24 2533.55 1880.78 2537.01 1876.53 2537.01H1648.01C1643.76 2537.01 1640.3 2533.55 1640.3 2529.29V2412.13C1640.3 2407.88 1643.76 2404.42 1648.01 2404.42H1876.53C1880.78 2404.42 1884.24 2407.88 1884.24 2412.13V2529.29Z"
                          fill="inherit"
                        />
                        <path
                          d="M2314.69 2391.81H2086.18C2074.97 2391.81 2065.86 2400.92 2065.86 2412.13V2529.29C2065.86 2540.5 2074.97 2549.62 2086.18 2549.62H2314.69C2325.9 2549.62 2335.02 2540.5 2335.02 2529.29V2412.13C2335.02 2400.92 2325.9 2391.81 2314.69 2391.81ZM2322.41 2529.29C2322.41 2533.55 2318.95 2537.01 2314.69 2537.01H2086.18C2081.93 2537.01 2078.47 2533.55 2078.47 2529.29V2412.13C2078.47 2407.88 2081.93 2404.42 2086.18 2404.42H2314.69C2318.95 2404.42 2322.41 2407.88 2322.41 2412.13V2529.29Z"
                          fill="inherit"
                        />
                        <path
                          d="M1431.26 2670.32H1216.95C1213.46 2670.32 1210.64 2673.14 1210.64 2676.63C1210.64 2680.12 1213.46 2682.94 1216.95 2682.94H1431.26C1434.74 2682.94 1437.56 2680.12 1437.56 2676.63C1437.56 2673.14 1434.74 2670.32 1431.26 2670.32Z"
                          fill="inherit"
                        />
                        <path
                          d="M1869.43 2670.32H1655.12C1651.64 2670.32 1648.82 2673.14 1648.82 2676.63C1648.82 2680.12 1651.64 2682.94 1655.12 2682.94H1869.43C1872.92 2682.94 1875.74 2680.12 1875.74 2676.63C1875.74 2673.14 1872.92 2670.32 1869.43 2670.32Z"
                          fill="inherit"
                        />
                        <path
                          d="M2307.6 2670.32H2093.29C2089.81 2670.32 2086.99 2673.14 2086.99 2676.63C2086.99 2680.12 2089.81 2682.94 2093.29 2682.94H2307.6C2311.09 2682.94 2313.91 2680.12 2313.91 2676.63C2313.91 2673.14 2311.09 2670.32 2307.6 2670.32Z"
                          fill="inherit"
                        />
                        <path
                          d="M1762.89 1565.91C1763.52 1565.91 1764.16 1565.9 1764.79 1565.9C1871.46 1564.86 1957.45 1477.87 1955.9 1370.35C1954.35 1263.99 1866.85 1178 1760.56 1178H1759.13C1652.05 1179.04 1566.47 1266.66 1568.02 1373.8C1569.57 1480.12 1656.81 1565.91 1762.9 1565.91H1762.89ZM1759.23 1190.62H1760.56C1859.99 1190.62 1941.83 1271.06 1943.28 1370.53C1944.76 1470.43 1864.96 1552.32 1764.66 1553.29C1764.07 1553.29 1763.48 1553.3 1762.89 1553.3C1663.67 1553.3 1582.08 1473.06 1580.62 1373.63C1579.17 1273.54 1659.14 1191.58 1759.23 1190.61V1190.62Z"
                          fill="inherit"
                        />
                        <path
                          d="M1703.91 1425.65C1713.33 1437.08 1728.51 1438.03 1739.66 1430.38L1844.33 1354.98C1844.33 1354.98 1844.37 1354.96 1844.38 1354.94C1856.27 1346.21 1858.22 1329.67 1849.86 1318.67C1841.36 1307.12 1825.51 1304.56 1813.64 1312.88L1729.19 1373.59L1715.53 1356.07C1706.69 1344.88 1690.35 1342.75 1678.96 1351.39C1667.5 1360.42 1665.8 1376.85 1674.53 1387.94L1703.91 1425.65Z"
                          fill="inherit"
                        />
                        <path
                          d="M2960.97 1963.85L2799.69 1965.25C2784.09 1965.4 2771.5 1978.2 2771.63 1993.83L2773.98 2211.08C2774.13 2226.6 2786.81 2239.14 2802.32 2239.14H2802.54L2963.82 2237.74C2979.45 2237.59 2992.06 2224.79 2991.91 2209.16L2989.57 1991.91C2989.42 1976.32 2976.8 1963.03 2960.98 1963.85H2960.97ZM2963.7 2225.14L2802.43 2226.54H2802.29C2793.69 2226.54 2786.65 2219.58 2786.58 2210.95L2784.23 1993.71C2784.16 1985.05 2791.15 1977.94 2799.8 1977.86L2961.07 1976.46C2969.35 1976.6 2976.87 1983.37 2976.96 1992.05L2979.3 2209.3C2979.37 2217.96 2972.38 2225.06 2963.71 2225.14H2963.7Z"
                          fill="inherit"
                        />
                        <path
                          d="M2804.39 1790.82C2807.55 1790.22 2810.72 1787.95 2810.7 1784.47L2808.37 1515.7C2808.35 1512.23 2805.53 1509.44 2802.07 1509.44H2802.02C2798.54 1509.46 2795.74 1512.32 2795.76 1515.79L2798.09 1784.56C2798.11 1788.03 2800.93 1790.82 2804.4 1790.82H2804.39Z"
                          fill="inherit"
                        />
                        <path
                          d="M2879.64 1790.17H2879.69C2883.18 1790.15 2885.97 1787.29 2885.95 1783.82L2881.57 1278.34C2881.55 1274.87 2878.73 1272.08 2875.26 1272.08H2875.21C2871.72 1272.1 2868.93 1274.96 2868.95 1278.43L2873.33 1783.91C2873.35 1787.38 2876.17 1790.17 2879.64 1790.17Z"
                          fill="inherit"
                        />
                        <path
                          d="M3134.42 1646.51C3131.16 1645.43 3127.56 1647.19 3126.44 1650.48C3125.33 1653.77 3127.1 1657.35 3130.41 1658.46C3138.62 1661.23 3161.47 1671.57 3168.46 1686.03C3170.98 1691.26 3171.24 1696.52 3169.22 1702.13C3159.47 1729.34 3115.91 1715.93 3115.44 1715.81C3112.13 1714.78 3108.58 1716.6 3107.53 1719.92C3106.48 1723.23 3108.32 1726.77 3111.63 1727.83C3118.56 1730.03 3128.11 1731.88 3138 1731.88C3177.32 1731.88 3189.85 1701.34 3179.81 1680.55C3169.1 1658.41 3135.84 1646.98 3134.42 1646.51Z"
                          fill="inherit"
                        />
                        <path
                          d="M3342.76 1681.52C3315.56 1711.57 3300.02 1765.97 3322.96 1811.82C3326.69 1819.23 3337.96 1813.64 3334.24 1806.18C3313.82 1765.39 3327.77 1716.86 3352.12 1689.99C3354.45 1687.4 3354.25 1683.41 3351.68 1681.07C3349.12 1678.77 3345.15 1678.95 3342.76 1681.51V1681.52Z"
                          fill="inherit"
                        />
                        <path
                          d="M947.793 201.54C730.013 201.54 552.843 378.71 552.843 596.49C552.843 599.98 555.663 602.8 559.153 602.8C562.643 602.8 565.463 599.98 565.463 596.49C565.463 385.67 736.983 214.15 947.803 214.15C951.293 214.15 954.113 211.33 954.113 207.84C954.113 204.35 951.293 201.54 947.803 201.54H947.793Z"
                          fill="inherit"
                        />
                        <path
                          d="M954.103 295.43C954.103 291.95 951.283 289.12 947.793 289.12C778.313 289.12 640.423 427 640.423 596.49C640.423 599.98 643.243 602.8 646.733 602.8C650.223 602.8 653.033 599.98 653.033 596.49C653.033 433.96 785.263 301.73 947.793 301.73C951.283 301.73 954.103 298.91 954.103 295.42V295.43Z"
                          fill="inherit"
                        />
                        <path
                          d="M734.313 602.8C737.803 602.8 740.623 599.98 740.623 596.49C740.623 482.25 833.563 389.31 947.803 389.31C951.293 389.31 954.113 386.49 954.113 383.01C954.113 379.53 951.293 376.7 947.803 376.7C826.613 376.7 728.013 475.3 728.013 596.49C728.013 599.98 730.833 602.8 734.313 602.8Z"
                          fill="inherit"
                        />
                        <path
                          d="M821.883 602.8C825.373 602.8 828.193 599.98 828.193 596.49C828.193 530.55 881.843 476.89 947.803 476.89C951.293 476.89 954.113 474.07 954.113 470.59C954.113 467.11 951.293 464.28 947.803 464.28C874.903 464.28 815.583 523.59 815.583 596.49C815.583 599.98 818.403 602.8 821.883 602.8Z"
                          fill="inherit"
                        />
                        <path
                          d="M972.293 621C991.823 601.47 991.823 569.69 972.293 550.16C952.683 530.52 920.933 530.68 901.453 550.16C881.923 569.69 881.923 601.46 901.453 621C920.963 640.51 952.763 640.53 972.293 621ZM910.363 559.07C924.793 544.64 948.543 544.24 963.373 559.07C977.993 573.69 977.993 597.47 963.373 612.08C948.773 626.7 924.993 626.67 910.363 612.08C895.763 597.46 895.763 573.67 910.363 559.07Z"
                          fill="inherit"
                        />
                        <path
                          d="M3696.66 100.43C3633.09 111.8 3584.35 166.04 3581.39 232.12H3666.12C3666.9 179.43 3677.4 125.71 3696.66 100.43Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M3678.84 244.73C3679.99 324.25 3701.79 379.31 3721.58 379.37C3721.6 379.37 3721.62 379.37 3721.65 379.37C3741.53 379.3 3763.43 324.24 3764.58 244.74H3678.84V244.73Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M3764.57 232.12C3763.41 152.98 3741.52 98.1999 3721.64 98.1299C3721.62 98.1299 3721.6 98.1299 3721.57 98.1299C3701.78 98.1799 3679.98 152.98 3678.83 232.13H3764.56L3764.57 232.12Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M3696.7 377.06C3677.41 351.7 3666.89 297.69 3666.12 244.74H3581.39C3584.33 311.14 3633.1 365.66 3696.7 377.06Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M3746.65 376.98C3810.31 365.39 3859.06 310.97 3862.01 244.73H3777.29C3776.51 297.63 3765.97 351.59 3746.64 376.98H3746.65Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M3862.01 232.12C3859.05 166.2 3810.32 112.05 3746.69 100.5C3765.99 125.81 3776.51 179.48 3777.3 232.12H3862.01Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M2867.23 928.66C2863.75 928.66 2860.92 931.48 2860.92 934.97C2860.92 938.46 2863.74 941.28 2867.23 941.28H3608.36C3611.85 941.29 3614.67 938.47 3614.67 934.99C3614.67 931.51 3611.85 928.69 3608.36 928.69H2867.23V928.66Z"
                          fill="inherit"
                        />
                        <path
                          d="M3679.77 882.73C3675.5 880.32 3670.32 883.4 3670.32 888.2V981.75C3670.32 986.57 3675.54 989.62 3679.77 987.22L3761.21 940.45C3765.42 938.04 3765.43 931.93 3761.21 929.51L3679.77 882.73ZM3682.93 970.86V899.09L3745.4 934.97L3682.93 970.85V970.86Z"
                          fill="inherit"
                        />
                        <path
                          d="M432.913 3139.54C447.763 3071.28 414.683 2933.78 413.333 2928.21C395.203 2836.74 354.153 2774.76 291.323 2744.01C169.213 2684.26 10.2131 2762.64 3.47306 2766C0.863061 2767.32 -0.506939 2770.25 0.173061 2773.09C0.833061 2775.93 3.37306 2777.94 6.30306 2777.94C7.62306 2777.94 139.733 2778.89 213.953 2851.58C235.083 2872.28 270.933 2934.85 305.593 2995.35C365.873 3100.56 396.293 3149.83 416.543 3153.49L417.133 3170.3H249.433C239.043 3170.3 230.593 3178.76 230.593 3189.15V3263.46C230.593 3273.85 239.043 3282.3 249.433 3282.3H755.023C765.413 3282.3 773.873 3273.85 773.873 3263.46V3189.15C773.873 3178.76 765.413 3170.3 755.023 3170.3H627.153C628.013 3127.06 630.233 3083.42 633.623 3040.16C659.103 3026.37 813.723 2938.29 848.403 2812.48C885.313 2678.54 1029.45 2651.62 1030.9 2651.36C1036.94 2650.29 1038.04 2642.04 1032.48 2639.44C853.443 2555.49 768.743 2570.32 669.973 2702.95C586.703 2814.75 619.713 3028.3 621.163 3037.34C621.163 3037.36 621.193 3037.36 621.193 3037.38C617.693 3081.57 615.423 3126.15 614.553 3170.31H557.193C551.553 2982.59 554.963 2830.53 567.333 2718.2C588.003 2704.89 729.893 2607.28 752.373 2422.4C775.473 2232.38 892.693 2113.81 893.883 2112.63C897.833 2108.71 895.103 2101.94 889.513 2101.85C888.033 2102.08 723.063 2101.17 618.243 2229.16C530.543 2336.26 509.293 2499.51 555.053 2714.34C542.423 2827.39 538.913 2980.85 544.593 3170.3H488.503C487.073 2946.63 503.753 2928.35 499.573 2895.72C523.893 2577.24 476.693 2370.43 359.263 2281.07C261.133 2206.4 148.313 2245.8 147.183 2246.21C141.503 2248.27 141.703 2256.43 147.493 2258.18C225.643 2281.91 308.133 2481.8 339.743 2653.37C369.433 2814.56 469.133 2887.06 487.193 2899.02C490.313 2928.49 474.503 2954.24 475.893 3170.29H429.793L429.033 3148.59C430.613 3146.42 432.053 3143.68 432.953 3139.51L432.913 3139.54ZM680.093 2710.49C769.493 2590.45 843.323 2568.04 1010.92 2643.43C969.383 2655.66 867.263 2696.6 836.243 2809.15C805.703 2919.97 672.803 3003.15 634.853 3024.97C653.153 2829.36 873.433 2658.27 875.663 2656.55C878.433 2654.43 878.953 2650.48 876.833 2647.72C874.713 2644.92 870.713 2644.41 868.003 2646.55C865.873 2648.18 669.253 2800.88 628.443 2985.23C623.523 2914.65 623.773 2786.11 680.103 2710.5L680.093 2710.49ZM627.883 2237.28C710.613 2136.15 832.583 2118.29 874.553 2115.13C844.603 2149.68 759.363 2260.43 739.853 2420.87C720.103 2583.25 605.433 2676.07 569.343 2701.58C602.053 2446.67 745.143 2206.04 746.603 2203.6C748.393 2200.61 747.433 2196.74 744.453 2194.94C741.463 2193.19 737.603 2194.1 735.793 2197.1C734.363 2199.49 598.933 2427.2 560.303 2675.51C525.173 2482.6 547.763 2335.23 627.883 2237.28ZM352.123 2651.09C321.353 2484.11 246.063 2298.55 168.093 2253.62C201.823 2246.24 280.883 2237.2 351.753 2291.24C459.873 2373.66 507.013 2571.04 489.023 2862.6C427.383 2719.38 386.453 2437.88 386.043 2435C385.543 2431.55 382.283 2429.26 378.903 2429.66C375.453 2430.15 373.063 2433.35 373.563 2436.8C373.993 2439.76 416.803 2734.4 481.223 2876.29C481.753 2877.47 482.083 2878.72 482.543 2879.92C451.293 2855.12 376.523 2783.55 352.133 2651.1L352.123 2651.09ZM761.273 3189.16V3263.47C761.273 3266.91 758.473 3269.7 755.033 3269.7H249.433C245.993 3269.7 243.203 3266.9 243.203 3263.47V3189.16C243.203 3185.71 246.003 3182.92 249.433 3182.92C280.023 3182.92 785.023 3182.92 755.023 3182.92C758.473 3182.92 761.263 3185.72 761.263 3189.16H761.273ZM316.553 2989.09C279.843 2925.02 245.163 2864.5 222.783 2842.57C165.143 2786.12 77.2731 2770.92 33.2531 2766.84C82.2731 2747.43 196.453 2711.61 285.843 2755.36C344.913 2784.29 383.653 2843.27 401.033 2930.93C401.313 2932.08 424.233 3027.6 424.053 3097.58C395.533 2909.63 251.433 2812.01 249.863 2810.96C246.943 2809.01 243.043 2809.86 241.133 2812.75C239.213 2815.66 240.013 2819.56 242.923 2821.48C244.563 2822.58 405.073 2931.43 415.783 3140.64C397.853 3130.96 349.363 3046.34 316.563 2989.09H316.553Z"
                          fill="inherit"
                        />
                        <path
                          d="M2642.17 423.17C2661.52 423.17 2677.25 407.42 2677.25 388.07V333.84C2677.25 314.49 2661.51 298.76 2642.17 298.76H2587.94C2568.59 298.76 2552.84 314.5 2552.84 333.84V388.07C2552.84 407.42 2568.59 423.17 2587.94 423.17H2642.17ZM2565.45 388.07V333.84C2565.45 321.45 2575.54 311.37 2587.94 311.37H2642.17C2654.56 311.37 2664.64 321.46 2664.64 333.84V388.07C2664.64 400.47 2654.55 410.56 2642.17 410.56H2587.94C2575.54 410.56 2565.45 400.47 2565.45 388.07Z"
                          fill="inherit"
                        />
                        <path
                          d="M288.283 1613.69C288.283 1763.1 409.753 1884.66 559.063 1884.66C708.373 1884.66 830.013 1763.1 830.013 1613.69C830.013 1464.28 711.853 1346.65 565.403 1343.24V1025.36H586.333C605.663 1025.36 621.393 1009.63 621.393 990.31V966.85H1082.41V2745.1C1082.41 2770.82 1098.65 2793.41 1122.89 2801.3C1329.01 2866.36 1545.58 2898.88 1762.23 2898.88C1978.88 2898.88 2195.6 2866.35 2401.88 2801.28C2426.04 2793.31 2442.27 2770.74 2442.27 2745.1V2586.59H2497.32C2515.74 2586.59 2530.73 2571.6 2530.73 2553.19V913.55C2530.73 895.13 2515.74 880.14 2497.32 880.14H2442.27V773.64H3050.68C3054.17 773.64 3056.99 770.82 3056.99 767.34V245.05H3483.31C3486.93 373.91 3591.55 477.49 3721.2 477.49C3850.85 477.49 3960.46 370.27 3960.46 238.23C3960.46 106.19 3853.13 0 3721.19 0C3589.25 0 3486.34 103.31 3483.25 232.44H3050.68C3047.19 232.44 3044.37 235.26 3044.37 238.75V761.04H2442.27V696.49C2442.27 671.12 2425.63 648.12 2401.8 640.55C2326.42 616.72 2247.73 596.87 2167.89 581.4L2170.9 139.42C2171.15 85.36 2127.69 41.53 2073.54 41.53C583.573 41.53 1754.38 41.45 1285.2 41.73C1231.39 42 1187.45 85.69 1187.18 139.4L1186.44 275.59C1186.41 279.03 1189.2 281.93 1192.74 281.93H1369.23L1367.31 579.38C1284.57 595 1202.36 615.53 1122.88 640.55C1098.66 648.15 1082.39 670.63 1082.39 696.49V954.24H621.373V935.83C621.373 916.5 605.643 900.77 586.313 900.77H532.093C512.763 900.77 497.033 916.5 497.033 935.83V990.31C497.033 1009.63 512.763 1025.36 532.093 1025.36H552.773V1343.24C406.373 1346.61 288.263 1466.51 288.263 1613.69H288.283ZM3721.38 85.51C3721.44 85.51 3721.49 85.51 3721.54 85.51C3721.56 85.51 3721.58 85.51 3721.6 85.51C3721.64 85.51 3721.68 85.53 3721.73 85.53C3806.24 85.72 3874.94 154.23 3874.94 238.43C3874.94 322.63 3806.24 391.78 3721.73 391.97C3721.69 391.97 3721.65 391.99 3721.6 391.99C3636.12 391.99 3568.46 322.25 3568.46 238.43C3568.46 154.61 3637.06 85.51 3721.38 85.51ZM1365.66 835.32H1306.61C1303.12 835.32 1300.3 838.14 1300.3 841.63C1300.3 845.12 1303.12 847.93 1306.61 847.93C1304.09 847.93 1325.61 848.33 2217.99 847.93C2221.47 847.93 2224.29 845.11 2224.29 841.63C2224.29 838.15 2221.47 835.32 2217.99 835.32H2166.18L2166.56 791.32H2272.03C2299.85 791.32 2322.47 813.83 2322.47 841.5C2322.47 869.17 2299.85 891.94 2272.03 891.94H1252.4C1224.85 891.94 1201.96 869.66 1201.96 841.5C1201.96 813.34 1224.58 791.32 1252.4 791.32H1365.87L1365.67 835.32H1365.66ZM2073.55 54.14C2120.61 54.14 2158.53 92.2 2158.3 139.34C2157.91 196.65 2159.87 -91.53 2153.57 835.31H1378.27C1381.61 253.23 1373.11 1571.14 1382.96 139.47V139.42C1382.96 104.68 1365.1 71.92 1333.6 54.13C1447.58 54.13 1396.11 54.39 2073.55 54.13V54.14ZM1199.1 269.31L1199.8 139.47C1200.03 92.5 1238.57 54.29 1285.69 54.29C1332.81 54.29 1370.6 94.24 1370.17 139.35L1369.33 269.32H1199.1V269.31ZM1095.02 696.49C1095.02 676.17 1107.74 658.51 1126.68 652.56C1204.91 627.92 1285.81 607.62 1367.25 592.14L1366.04 778.71H1252.4C1217.64 778.71 1189.35 806.87 1189.35 841.5C1189.35 876.13 1217.54 904.55 1252.4 904.55H2272.03C2306.79 904.55 2335.08 876.26 2335.08 841.5C2335.08 806.74 2306.79 778.71 2272.03 778.71H2166.55L2167.82 594.17C2246.4 609.48 2323.79 629.11 2397.99 652.57C2416.63 658.49 2429.65 676.56 2429.65 696.5V2745.1C2429.65 2765.28 2416.9 2783.04 2398 2789.28C1987.95 2918.59 1536.46 2918.61 1126.73 2789.29C1107.75 2783.11 1095.01 2765.35 1095.01 2745.09V696.49H1095.02ZM509.673 990.31V935.83C509.673 923.45 519.743 913.38 532.123 913.38H586.343C598.723 913.38 608.793 923.45 608.793 935.83V990.31C608.793 1002.69 598.723 1012.75 586.343 1012.75H532.123C519.743 1012.75 509.673 1002.69 509.673 990.31ZM817.413 1613.69C817.413 1756.14 701.523 1872.05 559.073 1872.05C416.623 1872.05 300.903 1756.15 300.903 1613.69C300.903 1471.23 416.723 1355.53 559.073 1355.53C701.423 1355.53 817.413 1471.33 817.413 1613.69Z"
                           fill="inherit" class="fill-primary"
                        />
                        <path
                          d="M339.073 1613.71C339.073 1735.12 437.773 1833.88 559.083 1833.88C680.393 1833.88 779.253 1735.12 779.253 1613.71C779.253 1492.3 680.493 1393.7 559.083 1393.7C437.673 1393.7 339.073 1492.4 339.073 1613.71ZM559.083 1406.31C673.533 1406.31 766.643 1499.35 766.643 1613.71C766.643 1728.07 673.533 1821.27 559.083 1821.27C444.633 1821.27 351.683 1728.16 351.683 1613.71C351.683 1499.26 444.723 1406.31 559.083 1406.31Z"
                          fill="inherit"
                        />
                        <path
                          d="M553.593 1705.68C554.683 1720.56 551.753 1726.84 557.523 1726.75L563.333 1726.65C569.103 1726.56 565.973 1720.34 566.573 1705.59C590.793 1703.9 614.143 1694.86 624.423 1673.07C630.013 1661.16 630.213 1645.08 625.903 1635.08C607.333 1591.87 512.863 1611.35 512.153 1567.12C511.843 1547.83 526.533 1536.76 545.563 1533.5C589.673 1526.03 602.303 1546.28 609.803 1549.83C612.853 1551.3 614.143 1547.65 617.623 1544.4C619.573 1542.03 619.263 1539.64 617.403 1537.85C605.593 1525.63 589.743 1517.39 563.403 1517.21L563.143 1501.63C563.063 1496.37 557.833 1498.65 553.813 1498.21C551.423 1498.25 550.253 1499.45 550.293 1501.84L550.553 1517.79C511.923 1521.84 495.933 1542.6 496.323 1566.89C497.413 1632.32 611.803 1600.03 612.683 1650.69C612.793 1657.7 611.533 1663.71 608.903 1668.74C594.243 1696.56 541.843 1697.71 516.113 1677.61C505.943 1669.63 503.323 1662.59 499.303 1666.38C494.893 1671.45 490.713 1672.27 495.533 1677.94C510.963 1695.25 529.483 1704.55 553.593 1705.68Z"
                          fill="inherit"
                        />
                        <path
                          d="M4300 1549.44C4300 1545.96 4297.18 1543.14 4293.69 1543.14C4290.2 1543.14 4287.38 1545.96 4287.38 1549.44V1819.46C4206.66 1758.34 3697.67 1374.81 3612.4 1358.37C3542.56 1344.9 3496.29 1372.38 3476.79 1387.76C3475.03 1334.48 3473.08 1281.02 3470.74 1227.36C3469.58 1198.75 3447.11 1176.54 3418.22 1175.66C3327.84 1176.42 3339.34 1176.32 2726.42 1181.47C2698.9 1182.9 2676.45 1205.82 2675.3 1233.98L2684.88 2285.09C2686.04 2313.13 2708.02 2335.36 2736.39 2336.79L3429 2330.23C3456.93 2328.52 3479.24 2305.32 3479.81 2277.45C3480.26 2260.65 3480.62 2243.99 3481.02 2227.27C3483.54 2227.07 3505.07 2228.31 3524.59 2211.53C3543.05 2195.66 3553.32 2169.35 3555.22 2133.2C3571.31 2152.19 3602.1 2180.49 3631.34 2163.16C3662.29 2144.71 3669.9 2102.14 3671.8 2083.31C3760 2125.53 3815.77 2126.59 3813.25 2126.21C3815.78 2126.22 3827.22 2127.18 3835.3 2126.23C3854.05 2139.34 3995.69 2234.5 4154.25 2234.5C4198.09 2234.5 4243.2 2226.78 4287.39 2208.48V2347.25C4287.39 2350.73 4290.21 2353.55 4293.7 2353.55C4297.19 2353.55 4300.01 2350.73 4300.01 2347.25V1549.45L4300 1549.44ZM3458.14 1227.89C3465.18 1388.84 3469.7 1588.17 3470.65 1653.22C3431.27 1647.64 3408.38 1641.99 3373.1 1633.02L3369.16 1188.68L3418.1 1188.27C3440.03 1188.93 3457.25 1205.95 3458.13 1227.89H3458.14ZM3211.19 1600.94L3207.75 1190.04C3210.29 1190.02 3366.51 1188.75 3356.56 1188.83L3360.46 1629.93C3315.03 1619.01 3258.42 1605.72 3211.18 1600.94H3211.19ZM2697.51 2284.77L2687.93 1234.18C2688.8 1212.78 2706.01 1195.16 2726.82 1194.07L3195.15 1190.14L3198.58 1600.02C3121.96 1594.32 3074.06 1612.83 3048.86 1658.35C3004.2 1739.22 3114.16 1789.6 3200.7 1820.64L3204.9 2319.76L2736.68 2324.2C2715.24 2323.1 2698.41 2306.07 2697.52 2284.78L2697.51 2284.77ZM3362.6 1876.63L3366.54 2318.19L3217.5 2319.58L3213.34 1825.19C3286.35 1850.62 3314.22 1853.88 3362.6 1876.63ZM3428.58 2317.62L3379.16 2318.09L3375.27 1882.83C3408.93 1899.69 3439.16 1919.69 3469.74 1942.05C3469.18 2069.65 3468.68 2223.51 3467.23 2277.14C3466.8 2298.53 3449.68 2316.31 3428.59 2317.62H3428.58ZM3624.91 2152.31C3593.98 2170.61 3554.84 2111.99 3554.46 2111.39C3551.01 2106.16 3542.75 2108.64 3542.88 2114.99C3543.77 2156.7 3534.9 2185.91 3516.54 2201.82C3503.76 2212.92 3489.59 2214.74 3481.34 2214.63C3483.36 2125.65 3484.53 2038.16 3484.8 1953.58C3551.05 2003.48 3601.66 2048.14 3659.68 2077.34C3658.76 2090.24 3653.57 2135.23 3624.91 2152.32V2152.31ZM3858.95 2126.73C3953.5 2132.05 3965.26 2150.72 3968.86 2138C3969.81 2134.65 3967.85 2131.17 3964.5 2130.22C3905.38 2113.55 3839.56 2113.35 3836.06 2113.4C3782.68 2121.05 3667.17 2067.19 3673.07 2070C3549.52 2008.22 3458.33 1886.86 3310.11 1842.73C3242.86 1822.8 3079.05 1776.84 3054.55 1712.32C3048.76 1697.07 3050.5 1681.42 3059.88 1664.45C3095.48 1600.12 3180.71 1607.21 3252.86 1619.71C3296.36 1627.25 3364.49 1643.54 3391.28 1650.61C3493.4 1676.36 3565.11 1671.73 3562.5 1671.73C3565.05 1671.42 3607.08 1670.14 3628.99 1663.38C3632.31 1662.35 3634.16 1658.82 3633.14 1655.5C3632.12 1652.18 3628.61 1650.3 3625.26 1651.34C3624.92 1651.45 3600.66 1658.34 3555.26 1658.96L3551.01 1658.87C3543.88 1658.71 3538.17 1652.92 3538.28 1645.98C3538.61 1623.04 3545.88 1591.14 3578.56 1569.46C3581.47 1567.53 3582.25 1563.61 3580.33 1560.72C3578.36 1557.79 3574.43 1557.05 3571.59 1558.95C3532.37 1585 3525.98 1624.54 3525.67 1645.79C3525.6 1650.52 3527.23 1654.75 3529.49 1658.58C3515.63 1658.04 3500.52 1656.96 3483.77 1654.98C3479.4 1479.86 3482.97 1599.67 3477.39 1403.97C3486.76 1395.15 3533.53 1355.92 3610.05 1370.77C3695.01 1387.14 4246.17 1804.04 4287.42 1835.31V2195.12C4111.84 2271.28 3918.25 2164.3 3858.97 2126.75L3858.95 2126.73Z"
                          fill="inherit"
                        />
                        <path
                          d="M4300 2419.22C4300 2415.74 4297.18 2412.91 4293.69 2412.91C4290.2 2412.91 4287.38 2415.73 4287.38 2419.22V2503.82C4287.38 2507.31 4290.2 2510.13 4293.69 2510.13C4297.18 2510.13 4300 2507.31 4300 2503.82V2419.22Z"
                          fill="inherit"
                        />
                      </svg>
                    </div>
                  </div>
                  <div class="form-action justify-content-between last-step">
                    <button type="button" class="i-btn btn--dark outline btn--md step-back-btn"> {{ translate("Previous") }} </button>
                    <a href="" class="i-btn btn--primary btn--md proceed">{{ translate('Pay Now')}}</a>
                    <button type="button" class="i-btn btn--primary btn--md step-next-btn"> {{ translate("Next") }} </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
</main>
@endsection
@push('script-include')
    <script src="{{asset('assets/theme/user/js/stage-step.js')}}"></script>
@endpush
@push('script-push')
<script>
	(function($){
		"use strict";
        $(document).on('click', '.form-check-input', function() {

          $('.payment-gateway-selection-next').removeClass('d-none')

        });

        $(document).on('click', '.register-payment-log', function() {
            var id = {{ $id }};
            var payment_gateway = $('input[name="payment_gateway"]:checked').attr('id').split('-')[1];
            var status = "{{ \App\Enums\SubscriptionStatus::REQUESTED->value }}";
            $.ajax({
                url: '{{ route("user.plan.store") }}',
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                    payment_gateway: payment_gateway,
                    status: status
                },
                success: function(response) {
                    notify(response.status, response.message);

                    var planName = response.data.plan.name;
                    var gatewayName = response.data.payment_method.name;
                    var amount = response.data.payment_log.amount.toFixed(2);
                    var charge = response.data.payment_log.charge.toFixed(2);
                    var finalAmount = response.data.payment_log.final_amount.toFixed(2);
                    var payable = parseFloat(amount) + parseFloat(charge);

                    $('.plan-name span').text(planName);
                    $('.payment-method-name span').text(gatewayName);
                    $('.payment-log-amount span').text('$' + amount);
                    $('.payment-log-charge span').text('$' + charge);
                    $('.payment-log-total span').text('$' + payable.toFixed(2));
                    $('.payment-final-amount span').text('$' + finalAmount);

                    if (response.data.payment_method.unique_code.includes('MANUAL')) {
                        var paymentMethod = response.data.payment_method;
                        var paymentLog = response.data.payment_log;
                        var plan = response.data.plan;

                        var manualTitle = `${paymentMethod.name} is being used to purchase ${plan.name} at $${paymentLog.final_amount.toFixed(2)}`;
                        var gwInfo = paymentMethod.payment_parameter[0].payment_gw_info;

                        var fieldsHtml = `
                            <form id="manual-payment-form" action="{{ route('user.manual.payment.update') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row g-4">
                                  <div class="col-12">
                                    <div class="bg-light rounded-2 p-3 fs-15 text-muted border h-100">
                                        <p class="fs-16 fw-semibold mb-3 manual-title">${manualTitle}</p>
                                        <p class="fs-14 manual-payment-parameter-gw-info">${gwInfo}</p>
                                    </div>
                                  </div>
                                
                        `;

                        $.each(paymentMethod.payment_parameter, function(key, parameter) {
                            if (parameter.field_type) {
                                var fieldLabel = parameter.field_label;
                                var fieldName = parameter.field_name;
                                var fieldType = parameter.field_type;
                                if (fieldType === 'text') {
                                    fieldsHtml += `
                                        <div class="col-12">
                                          <div class="form-inner">
                                            <label for="${fieldName}" class="form-label">${fieldLabel}</label>
                                            <input type="text" id="${fieldName}" class="form-control" name="${fieldName}" aria-label="${fieldLabel}" placeholder="${fieldLabel}" />
                                          </div>
                                        </div>
                                    `;
                                } else if (fieldType === 'textarea') {
                                    fieldsHtml += `
                                        <div class="col-12">
                                          <div class="form-inner">
                                            <label for="${fieldName}" class="form-label">${fieldLabel}</label>
                                            <textarea id="${fieldName}" class="form-control" name="${fieldName}" aria-label="${fieldLabel}" placeholder="${fieldLabel}"></textarea>
                                          </div>
                                        </div>
                                    `;
                                } else if (fieldType === 'file') {
                                    fieldsHtml += `
                                        <div class="col-12">
                                          <div class="form-inner">
                                            <label for="${fieldName}" class="form-label">${fieldLabel}</label>
                                            <input type="file" id="${fieldName}" class="form-control" name="${fieldName}" aria-label="${fieldLabel}" />
                                          </div>
                                        </div>
                                    `;
                                }
                            }
                        });

                        fieldsHtml += `</div></form>`;
                        $(".automatic-field").addClass("d-none");
                        $('.add-manual-fields').html(fieldsHtml);
                        $('.proceed').removeClass('proceed').addClass('manual-proceed');
                    } else {
                        $('.add-manual-fields').html('');
                        $('.manual-proceed').removeClass('manual-proceed').addClass('proceed').attr('href', '{{ route("user.payment.confirm") }}');
                    }
                }
            });
        });

        $(document).on('change', 'input[name="payment_gateway"]', function() {
            var payment_gateway = $('input[name="payment_gateway"]:checked').attr('id').split('-')[1];
            if (payment_gateway.includes('MANUAL')) {
                $('.proceed').removeClass('proceed').addClass('manual-proceed').removeAttr('href');
            } else {
                $('.manual-proceed').removeClass('manual-proceed').addClass('proceed').attr('href', '{{ route("user.payment.confirm") }}');
            }
        });

        $(document).on('click', '.manual-proceed', function(e) {
            e.preventDefault();
            $('#manual-payment-form').submit();
        });
        $(document).on('click', '.proceed', function(e) {
          $('.proceed').attr('href', '{{ route("user.payment.confirm", $id) }}').submit();
        });



	})(jQuery);
</script>
@endpush
