@extends('admin.layouts.app')
@section('panel')

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2>{{ $title }}</h2>
                <div class="breadcrumb-wrapper">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route("admin.dashboard") }}">{{ translate("Dashboard") }}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"> {{ $title }} </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="table-filter mb-4">
            <form action="{{route(Route::currentRouteName())}}" class="filter-form">
                
                <div class="row g-3">
                    <div class="col-lg-4">
                        <div class="filter-search">
                            <input type="search" value="{{request()->search}}" name="search" class="form-control" id="filter-search" placeholder="{{ translate("Filter by name, email or subject") }}" />
                            <span><i class="ri-search-line"></i></span>
                        </div>
                    </div>

                    <div class="col-xxl-5 col-lg-7 offset-xxl-3">
                        <div class="filter-action">
                            <div class="input-group">
                                <input type="text" class="form-control" id="datePicker" name="date" value="{{request()->input('date')}}"  placeholder="{{translate('Filter by date')}}"  aria-describedby="filterByDate">
                                <span class="input-group-text" id="filterByDate">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>

                            <div class="d-flex align-items-center gap-3">
                                <button type="submit" class="filter-action-btn ">
                                    <i class="ri-menu-search-line"></i> {{ translate("Filters") }}
                                </button>
                                <a class="filter-action-btn bg-danger text-white" href="{{route(Route::currentRouteName())}}">
                                    <i class="ri-refresh-line"></i> {{ translate("Reset") }}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="card-header-left">
                    <h4 class="card-title">{{ translate("Ticket List") }}</h4>
                </div>
            </div>
            <div class="card-body px-0 pt-0">
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th scope="col">{{ translate("Date") }}</th>
                                <th scope="col">{{ translate("Subject") }}</th>
                                <th scope="col">{{ translate("Submitted By") }}</th>
                                <th scope="col">{{ translate("Priority") }}</th>
                                <th scope="col">{{ translate("Status") }}</th>
                                <th scope="col">{{ translate("Option") }}</th>
                            </tr>
                        </thead>
                        <tbody>

                            @forelse($supportTickets as $supportTicket)
                                <tr class="@if($loop->even)@endif">
                                    <td data-label="{{ translate('Date')}}">
                                        <span>{{diffForHumans($supportTicket->created_at)}}</span><br>
                                        <p class="text-dark fw-semibold">{{getDateTime($supportTicket->created_at)}}</p>
                                    </td>
                                    <td data-label="{{ translate('Subject')}}">
                                        <p class="text-dark fw-semibold"><a href="{{route('admin.support.ticket.details', $supportTicket->id)}}">{{$supportTicket->subject}}</a></p>
                                    </td>
                                    <td data-label="{{ translate('Submitted By')}}">
                                        <a href="{{route('admin.user.details',$supportTicket->user_id)}}" class="fw-bold text-dark link-underline ">{{$supportTicket->user?->email}}</a>
                                    </td>
                                    <td data-label="{{ translate('Priority')}}">
                                        @php echo priority_status($supportTicket->priority) @endphp
                                    </td>
                                    <td data-label="{{ translate('Status')}}">
                                        @php echo support_ticket_status($supportTicket->status) @endphp
                                    </td>

                                    <td data-label="{{ translate('Option')}}">
                                        <div class="d-flex align-items-center gap-1">
                                            <a href="{{route('admin.support.ticket.details', $supportTicket->id)}}" class="icon-btn btn-ghost btn-sm info-soft circle text-danger">
                                                <i class="ri-ticket-2-line"></i>
                                                <span class="tooltiptext"> {{ translate("View Ticket") }} </span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%">{{ translate('No Data Found')}}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="pagination-wrapper px-4 pt-3">
                    <p class="pagination-summary">
                        @if ($supportTickets->appends(request()->all()))
                            {{ translate("Showing") }} {{ $supportTickets->appends(request()->all())->firstItem() }}-{{ $supportTickets->appends(request()->all())->lastItem() }} {{ translate("from") }} {{ $supportTickets->appends(request()->all())->total() }}
                        @endif
                    </p>
                    <nav aria-label="...">
                        @if ($supportTickets->appends(request()->all())->hasPages())
                            <nav aria-label="...">
                                <ul class="pagination">
                                    @if ($supportTickets->appends(request()->all())->onFirstPage())
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item">
                                            <a class="page-link" href="{{ $supportTickets->appends(request()->all())->previousPageUrl() }}" rel="prev">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    @endif
                                    @foreach ($supportTickets->appends(request()->all())->links()->elements as $element)

                                        @if(is_array($element))
                                            @foreach ($element as $url)

                                                @php
                                                    if(request()->input("date")) {
                                                        $query_step = 4;
                                                    }
                                                    elseif(request()->input("search")) {
                                                        $query_step = 3;
                                                    } elseif(request()->_token) {
                                                        $query_step = 2;
                                                    } else{
                                                        $query_step = 1;
                                                    }

                                                    $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                                @endphp
                                                @if ($page == $supportTickets->appends(request()->all())->currentPage())

                                                    <li class="page-item active" aria-current="page">
                                                        <span class="page-link">{{ $page }}</span>
                                                    </li>
                                                @else

                                                    <li class="page-item">
                                                        <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                                                    </li>
                                                @endif
                                            @endforeach
                                        @else
                                            <li class="page-item" aria-current="page">
                                                <span class="page-link">{{ "..."}}</span>
                                            </li>
                                        @endif
                                    @endforeach
                                    @if ($supportTickets->appends(request()->all())->hasMorePages())
                                        <li class="page-item">
                                            <a class="page-link" href="{{ $supportTickets->appends(request()->all())->nextPageUrl() }}" rel="next">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    </nav>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
@push('script-push')
<script>
	"use strict";

        flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });
</script>
@endpush



