<header class="header">
    <div class="header-left">
    <div class="header-action d-lg-none">
        <button class="btn-icon" type="button" id="sidebar-handler">
        <i class="ri-menu-2-fill"></i>
        </button>
    </div>
    <div class="header-action d-sm-flex d-none">
        <a href="<?php echo e(route('admin.system.cache.clear')); ?>" class="btn-icon">
        <i class="ri-refresh-line"></i>
        </a>
    </div>
    <div class="header-action d-sm-flex d-none">
        <a href="<?php echo e(url('/')); ?>" target="_blank" class="btn-icon">
        <i class="ri-earth-line"></i>
        </a>
    </div>
    </div>
    <div class="header-right">
        <div class="header-action">
            <div class="header-action">
                <form class="settingsForm themeForm" method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="site_settings[theme_mode]" id="theme_mode" value="<?php echo e(site_settings('theme_mode') == \App\Enums\StatusEnum::FALSE->status() ? \App\Enums\StatusEnum::TRUE->status() : \App\Enums\StatusEnum::FALSE->status()); ?>">
                    <button class="btn-icon theme-toggler" type="button">
                        <?php if(site_settings('theme_mode') == \App\Enums\StatusEnum::FALSE->status()): ?>
                            <i class="ri-sun-line"></i>
                        <?php else: ?>
                            <i class="ri-moon-line"></i>
                        <?php endif; ?>
                    </button>
                </form>
            </div>
        </div>
        <div class="header-action">
            <div class="lang-dropdown">
                <div class="btn-icon dropdown-toggle" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <span class="flag-img">
                        
                        <img class="lang-image" src="<?php echo e(asset('assets/theme/global/images/flags/' . App::getLocale() . '.svg')); ?>" alt="<?php echo e(App::getLocale()); ?>" />
                    </span>
                </div>
                <div class="dropdown-menu dropdown-menu-end">
                    <ul>
                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a class="pointer" onclick="changeLang('<?php echo e($language->id); ?>', '<?php echo e($language->code); ?>')">
                                    <i class="flag-icon-<?php echo e($language->code); ?> flag-icon flag-icon-squared rounded-circle"></i>
                                    <?php echo e($language->name); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="header-action">
            <div class="profile-dropdown">
            <div class="topbar-profile dropdown-toggle" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <span class="profile-avatar">
                    <img src="<?php echo e(showImage(config('setting.file_path.admin_profile.path').'/'.auth()->guard('admin')->user()->image, config('setting.file_path.admin_profile.size'))); ?>" alt="<?php echo e(auth()->guard('admin')->user()->username); ?>">
                </span>
                <div class="topbar-profile-info d-sm-block d-none">
                <p><?php echo e(ucfirst(auth()->guard('admin')->user()->username)); ?></p>
                <span><?php echo e(auth()->guard('admin')->user()->name); ?></span>
                </div>
            </div>
            <div class="dropdown-menu dropdown-menu-end">
                <ul>
                <li>
                    <a class="dropdown-item" href="<?php echo e(route("admin.profile")); ?>">
                    <i class="ri-user-line"></i> <?php echo e(translate("My Account")); ?> </a>
                </li>
                <li>
                    <a class="dropdown-item" href="<?php echo e(route('admin.communication.api')); ?>">
                    <i class="ri-code-s-slash-line"></i> <?php echo e(translate("API")); ?> </a>
                </li>
                <li>
                    <a class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>">
                    <i class="ri-logout-box-line"></i> <?php echo e(translate("Logout")); ?> </a>
                </li>
                </ul>
            </div>
            </div>
        </div>
    </div>
</header>
<?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/partials/topbar.blade.php ENDPATH**/ ?>