<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?> 


<?php $__env->startSection('panel'); ?>

    <main class="main-body">
        <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
            <h2><?php echo e($title); ?></h2>
            <div class="breadcrumb-wrapper">
                <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                    <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
                </ol>
                </nav>
            </div>
            </div>
        </div>
        <div class="table-filter mb-4">
            <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
               
                <div class="row g-3">
                    <div class="col-xl-3 col-lg-3">
                        <div class="filter-search">
                            <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Filter by name")); ?>" />
                            <span><i class="ri-search-line"></i></span>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-9 offset-xl-2">
                        <div class="filter-action">
                            <select data-placeholder="<?php echo e(translate('Select A Status')); ?>" class="form-select select2-search" name="status" aria-label="Default select example">
                                <option value=""></option>
                                <option <?php echo e(request()->status == \App\Enums\StatusEnum::TRUE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Active")); ?></option>
                                <option <?php echo e(request()->status == \App\Enums\StatusEnum::FALSE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Inactive")); ?></option>
                            </select>
                            <div class="input-group">
                                <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                                <span class="input-group-text" id="filterByDate">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>
                            <button type="submit" class="filter-action-btn ">
                                <i class="ri-menu-search-line"></i> <?php echo e(translate("Filter")); ?> 
                            </button>
                            <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?> 
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("Membership Plans")); ?></h4>
                </div>
                <div class="card-header-right">
                    <div class="d-flex gap-3 align-item-center">
                        <button class="bulk-action i-btn btn--danger btn--sm bulk-delete-btn d-none">
                            <i class="ri-delete-bin-6-line"></i>
                        </button>

                        <div class="bulk-action form-inner d-none">
                            <select class="form-select" data-show="5" id="bulk_status" name="status">
                                <option disabled selected><?php echo e(translate("Select a status")); ?></option>
                                <option value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Active")); ?></option>
                                <option value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Inactive")); ?></option>
                            </select>
                        </div>
                        
                        <a class="i-btn btn--primary btn--sm" href="<?php echo e(route("admin.membership.plan.create")); ?>">
                            <i class="ri-add-fill fs-16"></i> <?php echo e(translate("Create Plan")); ?> 
                        </a>
                    </div>
                </div>
            </div>
        
            <div class="card-body px-0 pt-0">
            <div class="table-container">
                <table>
                <thead>
                    <tr>
                    <th scope="col">
                        <div class="form-check">
                        <input class="check-all form-check-input" type="checkbox" value="" id="checkAll" />
                        <label class="form-check-label" for="checkedAll"> <?php echo e(translate("SL No.")); ?> </label>
                        </div>
                    </th>
                    <th scope="col"><?php echo e(translate("Name")); ?></th>
                    <th scope="col"><?php echo e(translate("Amount")); ?></th>
                    <th scope="col"><?php echo e(translate("Credit & Duration")); ?></th>
                    <th scope="col"><?php echo e(translate("Status")); ?></th>
                    <th scope="col"><?php echo e(translate("Recommended Status")); ?></th>
                    <th scope="col"><?php echo e(translate("Option")); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="form-check">
                                    <input type="checkbox" value="<?php echo e($plan->id); ?>" name="ids[]" class="data-checkbox form-check-input" id="<?php echo e($plan->id); ?>" />
                                    <label class="form-check-label fw-semibold text-dark" for="bulk-<?php echo e($loop->iteration); ?>"><?php echo e($loop->iteration); ?></label>
                                </div>
                            </td>
                            <td>
                                <p class="text-dark"><?php echo e($plan->name); ?></p>
                            </td>
                            <td data-label="<?php echo e(translate('Amount')); ?>">
                                <?php echo e(shortAmount($plan->amount)); ?> <?php echo e(getDefaultCurrencyCode(json_decode(site_settings('currencies'), true))); ?>

                            </td>

                            <td data-label="<?php echo e(translate('Credits')); ?>">
                                <div class="d-flex flex-column gap-1 align-items-start ">
                                    <span><?php echo e(translate('Email Credit: ')); ?> <?php echo e($plan->email?->credits == -1 ? translate("Unlimited") : $plan->email?->credits); ?> / <?php echo e(@$plan->email?->credits_per_day == 0 ? translate("Unlimited") : @$plan->email?->credits_per_day); ?> <?php echo e(translate(" Per Day")); ?></span>
                                    <span><?php echo e(translate('SMS Credit:')); ?> <?php echo e($plan->sms?->credits == -1 ? translate("Unlimited") : $plan->sms?->credits); ?> / <?php echo e(@$plan->sms?->credits_per_day == 0 ? translate("Unlimited") : @$plan->sms?->credits_per_day); ?> <?php echo e(translate(" Per Day")); ?> </span>
                                    <span><?php echo e(translate('WhatsApp Credit:')); ?> <?php echo e($plan->whatsapp?->credits == -1 ? translate("Unlimited") : $plan->whatsapp?->credits); ?> / <?php echo e(@$plan->whatsapp?->credits_per_day == 0 ? translate("Unlimited") : @$plan->whatsapp?->credits_per_day); ?> <?php echo e(translate(" Per Day")); ?></span>
                                    <span><?php echo e(translate('Duration: ')); ?><?php echo e($plan->duration.translate(" Days")); ?> </span>
                                </div>
                            </td>
                            <td data-label="<?php echo e(translate('Status')); ?>">
                                <div class="switch-wrapper checkbox-data">
                                    <input <?php echo e($plan->status == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> 
                                            type="checkbox" 
                                            class="switch-input statusUpdate" 
                                            data-id="<?php echo e($plan->id); ?>"
                                            data-column="status"
                                            data-value="<?php echo e($plan->status); ?>"
                                            data-route="<?php echo e(route('admin.membership.plan.status.update')); ?>"
                                            id="<?php echo e('status_'.$plan->id); ?>" 
                                            name="is_default"/>
                                    <label for="<?php echo e('status_'.$plan->id); ?>" class="toggle">
                                        <span></span>
                                    </label>
                                </div>
                            </td>

                            <td data-label="<?php echo e(translate('Recommended Status')); ?>">
                                <?php if($plan->recommended_status == \App\Enums\StatusEnum::TRUE->status()): ?>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="i-badge dot success-soft pill"><?php echo e(translate("Recommended")); ?></span>
                                    </div>
                                <?php else: ?>
                                    <div class="switch-wrapper checkbox-data">
                                        <input <?php echo e($plan->recommended_status == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> 
                                                type="checkbox" 
                                                class="switch-input statusUpdate" 
                                                data-id="<?php echo e($plan->id); ?>"
                                                data-column="recommended_status"
                                                data-value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"
                                                data-route="<?php echo e(route('admin.membership.plan.status.update')); ?>"
                                                id="<?php echo e('recommended_status_'.$plan->id); ?>" 
                                                name="is_default"/>
                                        <label for="<?php echo e('recommended_status_'.$plan->id); ?>" class="toggle">
                                            <span></span>
                                        </label>
                                    </div>
                                <?php endif; ?>
                            </td>
                        
                            <td data-label=<?php echo e(translate('Option')); ?>>
                                <div class="d-flex align-items-center gap-1">
                                    <a class="icon-btn btn-ghost btn-sm success-soft circle" href="<?php echo e(route("admin.membership.plan.edit", $plan->id)); ?>">
                                        <i class="ri-edit-line"></i>
                                        <span class="tooltiptext"> <?php echo e(translate("Edit Membership Plan")); ?> </span>
                                    </a>
                                    <button class="icon-btn btn-ghost btn-sm danger-soft circle text-danger delete-membership-plan" 
                                            type="button" 
                                            data-plan-id="<?php echo e($plan->id); ?>"
                                            data-bs-toggle="modal" 
                                            data-bs-target="#deleteMembershipPlan">
                                        <i class="ri-delete-bin-line"></i>
                                        <span class="tooltiptext"> <?php echo e(translate("Delete Membership Plan")); ?> </span>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                    <?php endif; ?>
                </tbody>
                </table>
            </div>
                <div class="pagination-wrapper px-4 pt-3">
                    <p class="pagination-summary">
                        <?php if($plans->appends(request()->all())): ?>
                            <?php echo e(translate("Showing")); ?> <?php echo e($plans->appends(request()->all())->firstItem()); ?>-<?php echo e($plans->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($plans->appends(request()->all())->total()); ?>

                        <?php endif; ?>
                    </p>
                    <nav aria-label="...">
                        <?php if($plans->appends(request()->all())->hasPages()): ?>
                        <nav aria-label="...">
                            <ul class="pagination">
                                <?php if($plans->appends(request()->all())->onFirstPage()): ?>
                                    <li class="page-item disabled">
                                        <a class="page-link">
                                            <i class="bi bi-chevron-left"></i>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($plans->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                            <i class="bi bi-chevron-left"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                
                                
                                <?php $__currentLoopData = $plans->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <?php if(is_array($element)): ?>
                                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            
                                            <?php
                                                if(request()->input("date")) {
                                                    $query_step = 4;
                                                }
                                                elseif(request()->input("search") || request()->input("status")) {
                                                    $query_step = 3;
                                                } elseif(request()->_token) {
                                                    $query_step = 2;
                                                } else{
                                                    $query_step = 1;
                                                }
                                                
                                                $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                            ?>
                                            <?php if($page == $plans->appends(request()->all())->currentPage()): ?>
                                            
                                                <li class="page-item active" aria-current="page">
                                                    <span class="page-link"><?php echo e($page); ?></span>
                                                </li>
                                            <?php else: ?>
                                            
                                                <li class="page-item">
                                                    <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?> 
                                        <li class="page-item" aria-current="page">
                                            <span class="page-link"><?php echo e("..."); ?></span>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($plans->appends(request()->all())->hasMorePages()): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($plans->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                            <i class="bi bi-chevron-right"></i>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item disabled">
                                        <a class="page-link">
                                            <i class="bi bi-chevron-right"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        </div>
        </div>
    </main>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade actionModal" id="deleteMembershipPlan" tabindex="-1" aria-labelledby="deleteMembershipPlan" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
            <div class="modal-header text-start">
                <span class="action-icon danger">
                <i class="bi bi-exclamation-circle"></i>
                </span>
            </div>
            <form action="<?php echo e(route('admin.membership.plan.delete')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    
                    <input type="hidden" name="id">
                    <div class="action-message">
                        <h5><?php echo e(translate("Are you sure to delete this membership plan?")); ?></h5>
                        
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                    <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Delete")); ?> </button>
                </div>
            </form>
            </div>
        </div>
    </div>

    <div class="modal fade actionModal" id="bulkAction" tabindex="-1" aria-labelledby="bulkAction" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
            <div class="modal-header text-start">
                <span class="action-icon danger">
                <i class="bi bi-exclamation-circle"></i>
                </span>
            </div>
            <form action="<?php echo e(route('admin.membership.plan.bulk')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    
                    <input type="hidden" name="id" value="">
                    <div class="action-message">
                        <h5><?php echo e(translate("Are you sure to change the status for the selected data?")); ?></h5>
                        <p><?php echo e(translate("This action is irreversable")); ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                    <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Proceed")); ?> </button>
                </div>
            </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>  
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-push'); ?>
<script>
    (function($){
        "use strict";

        select2_search($('.select2-search').data('placeholder'));
        flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });

        $('.delete-membership-plan').on('click', function() {

            const modal = $('#deleteMembershipPlan');
            modal.find('input[name=id]').val($(this).data('plan-id'));
            modal.modal('show');
        });
    })(jQuery);

    
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/membership/plan/index.blade.php ENDPATH**/ ?>