
<?php $__env->startSection('tab-content'); ?>

<div class="tab-pane active fade show" id="<?php echo e(url()->current()); ?>" role="tabpanel">
    <div class="table-filter mb-4">
        <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
           
            <div class="row g-3">
                <div class="col-xxl-3 col-xl-4 col-lg-4">
                    <div class="filter-search">
                        <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Filter by name")); ?>" />
                        <span><i class="ri-search-line"></i></span>
                    </div>
                </div>

                <div class="col-xxl-5 col-xl-6 col-lg-7 offset-xxl-4 offset-xl-2">
                    <div class="filter-action">

                        <div class="input-group">
                            <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                            <span class="input-group-text" id="filterByDate">
                                <i class="ri-calendar-2-line"></i>
                            </span>
                        </div>


                        <div class="d-flex align-items-center gap-3">
                            <button type="submit" class="filter-action-btn ">
                                <i class="ri-menu-search-line"></i> <?php echo e(translate("Filter")); ?>

                            </button>
                            <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="card">
        <div class="card-header">
            <div class="card-header-left">
                <h4 class="card-title"><?php echo e($title); ?></h4>
            </div>
            <div class="card-header-right">

                <a class="i-btn btn--info btn--sm me-2" href="<?php echo e(route("admin.system.setting", ["type" => "webhook"])); ?>">
                    <i class="ri-server-line fs-16"></i> <?php echo e(translate("Configure Webhook")); ?>

                </a>
                <button class="i-btn btn--primary btn--sm add-whatsapp-business-account" type="button" data-bs-toggle="modal" data-bs-target="#addWhatsappBusinessAccount">
                    <i class="ri-add-fill fs-16"></i> <?php echo e(translate("Add Whatsapp Business Account")); ?>

                </button>
            </div>
        </div>

            <div class="card-body px-0 pt-0">
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(translate("Business Account Name")); ?></th>
                                <th scope="col"><?php echo e(translate("Templates")); ?></th>
                                <th scope="col"><?php echo e(translate("Option")); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tbody>
                                <tr>

                                    <td data-label="<?php echo e(translate('Business Account Name')); ?>"><?php echo e(textFormat(['_'],$item->name,' ')); ?></td>
                                    <td data-label="<?php echo e(translate('Templates')); ?>">
                                        <a href="<?php echo e(route('admin.template.whatsapp.index', ['id' => $item->id])); ?>" class="badge badge--primary p-2">
                                            <span class="i-badge info-solid pill">
                                                <?php echo e(translate('View all').' ('.count($item->template).') '); ?> <i class="ri-eye-line ms-1"></i>
                                            </span>
                                        </a>
                                    </td>
                                    <td data-label=<?php echo e(translate('Option')); ?>>
                                        <div class="d-flex align-items-center gap-1">
                                            <button class="icon-btn btn-ghost btn-sm info-soft circle update-whatsapp-business-account"
                                                    type="button"
                                                    data-id="<?php echo e($item->id); ?>"
                                                    data-name="<?php echo e($item->name); ?>"
                                                    data-credentials="<?php echo e(json_encode($item->credentials)); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#updateWhatsappBusinessAccount">
                                                <i class="ri-edit-line"></i>
                                                <span class="tooltiptext"> <?php echo e(translate("Update Android Gateway")); ?> </span>
                                            </button>
                                            <button type="button"
                                                    class="icon-btn btn-ghost btn-sm info-soft circle text-info sync"
                                                    data-value="<?php echo e($item->id); ?>">
                                                    <i class="ri-loop-right-line"></i>
                                                    <span class="tooltiptext"> <?php echo e(translate("Sync Business Account Template")); ?> </span>
                                            </button>
                                            <button class="icon-btn btn-ghost btn-sm danger-soft circle text-danger delete-whatsapp-cloud-api"
                                                    type="button"
                                                    data-item-id="<?php echo e($item->id); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#deleteWhatsappCloudApi">
                                                <i class="ri-delete-bin-line"></i>
                                                <span class="tooltiptext"> <?php echo e(translate("Delete Whatsapp Cloud Api")); ?> </span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                </tbody>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tbody>
                                <tr>
                                    <td colspan="50"><span class="text-danger"><?php echo e(translate('No data Available')); ?></span></td>
                                </tr>
                                </tbody>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="pagination-wrapper px-4 pt-3">
                    <p class="pagination-summary">
                        <?php if($gateways->appends(request()->all())): ?>
                            <?php echo e(translate("Showing")); ?> <?php echo e($gateways->appends(request()->all())->firstItem()); ?>-<?php echo e($gateways->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($gateways->appends(request()->all())->total()); ?>

                        <?php endif; ?>
                    </p>
                    <nav aria-label="...">
                        <?php if($gateways->appends(request()->all())->hasPages()): ?>
                            <nav aria-label="...">
                                <ul class="pagination">
                                    <?php if($gateways->appends(request()->all())->onFirstPage()): ?>
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($gateways->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                                <i class="bi bi-chevron-left"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $gateways->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php if(is_array($element)): ?>
                                            <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php
                                                    if(request()->input("date")) {
                                                        $query_step = 4;
                                                    }
                                                    elseif(request()->input("search")) {
                                                        $query_step = 3;
                                                    } elseif(request()->_token) {
                                                        $query_step = 2;
                                                    } else{
                                                        $query_step = 1;
                                                    }

                                                    $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                                ?>
                                                <?php if($page == $gateways->appends(request()->all())->currentPage()): ?>

                                                    <li class="page-item active" aria-current="page">
                                                        <span class="page-link"><?php echo e($page); ?></span>
                                                    </li>
                                                <?php else: ?>

                                                    <li class="page-item">
                                                        <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <li class="page-item" aria-current="page">
                                                <span class="page-link"><?php echo e("..."); ?></span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($gateways->appends(request()->all())->hasMorePages()): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e($gateways->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <a class="page-link">
                                                <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

<div class="modal fade" id="addWhatsappBusinessAccount" tabindex="-1" aria-labelledby="addWhatsappBusinessAccount" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.gateway.whatsapp.cloud.api.save')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Add WhatsApp Business Account")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-12">
                            <label class="form-label" for="name"><?php echo e(translate('Business Portfolio Name')); ?> <span class="text-danger">*</span></label>
                            <input type="text" class="mt-2 form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name" id="name" value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(translate('Add a name for your Business Portfolio')); ?>" autocomplete="true" aria-label="name">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <?php $__currentLoopData = $credentials["required"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creds_key => $creds_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="<?php echo e($loop->first ? 'col-12' : 'col-6'); ?> ">
                                <label class="form-label" for="<?php echo e($creds_key); ?>"><?php echo e(translate(textFormat(['_'], $creds_key))); ?> <span class="text-danger">*</span></label>
                                <input type="text" id="<?php echo e($creds_key); ?>" class="mt-2 form-control" name="credentials[<?php echo e($creds_key); ?>]" value="<?php echo e(old($creds_key)); ?>" placeholder="Enter the <?php echo e(translate(textFormat(['_'], $creds_key))); ?>"  aria-label="<?php echo e($creds_key); ?>" autocomplete="true">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="updateWhatsappBusinessAccount" tabindex="-1" aria-labelledby="updateWhatsappBusinessAccount" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.gateway.whatsapp.cloud.api.save')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Update WhatsApp Business Account Credentials")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-lg-12">
                            <label for="name" class="form-label"><?php echo e(translate('Business API Name')); ?> <sup class="text--danger">*</sup></label>
                            <div class="input-group">
                                  <input type="text" class="form-control" id="name" name="name" placeholder="<?php echo e(translate('Update Business API Name')); ?>" autocomplete="true">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="row" id="edit_cred"></div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade actionModal" id="deleteWhatsappCloudApi" tabindex="-1" aria-labelledby="deleteWhatsappCloudApi" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.gateway.whatsapp.device.delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input type="hidden" name="id" value="">
                <div class="action-message">
                    <h5><?php echo e(translate("Are you sure to delete this WhatsApp device?")); ?></h5>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Delete")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-push'); ?>
<script>
	(function($){
		"use strict";

        flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });

        $(document).ready(function() {

            $('.add-whatsapp-business-account').on('click', function() {

                const modal = $('#addAndroidGateway');
                modal.modal('show');
            });

            $('.update-whatsapp-business-account').on('click', function() {

                $("#edit_cred").empty();
                var credentials = $(this).data('credentials');
                const modal = $('#updateWhatsappBusinessAccount');
                modal.find('input[name=id]').val($(this).attr('data-id'));
                modal.find('input[name=name]').val($(this).attr('data-name'));
                var html = ``;
                var firstIteration = true;
                $.each(credentials, function(key, value) {

                    html += `
                        <div class="${firstIteration ? `col-lg-12` : `col-lg-6`}">
                            <label class="form-label mt-3" for="${key}">${textFormat(['_'],key)}<span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="credentials[${key}]" value="${value}" placeholder="Enter the ${key}">
                        </div>
                    `;
                    firstIteration = false;
                });
                $("#edit_cred").append(html);
                modal.modal('show');
            });

            $('.sync').click(function(e) {

                var itemId = $(this).attr('data-value');
                var csrfToken = $('meta[name="csrf-token"]').attr('content');
                var button = $(this);
                var originalIcon = button.find('i').detach();
                if (button.hasClass('disabled')) {
                    return;
                }
                button.append('<span class="loading-spinner spinner-border spinner-border-sm" aria-hidden="true"></span> ');
                button.addClass('disabled');

                $.ajax({
                    url: '<?php echo e(route("admin.template.refresh")); ?>',
                    type: 'GET',
                    data: {
                        itemId: itemId
                    },
                    dataType: 'json',
                    headers: {
                        'X-CSRF-TOKEN': csrfToken
                    },
                    success: function(response) {

                        button.find('.loading-spinner').remove();
                        button.removeClass('disabled').prepend(originalIcon);

                        if(response.status && response.reload) {
                            location.reload(true);
                            notify('success', response.message);
                        } else {
                            notify('error', response.message);
                        }
                    },
                    error: function(xhr, status, error) {

                        button.find('.loading-spinner').remove();
                        button.removeClass('disabled').prepend(originalIcon);
                        notify('error', "Some error occurred");
                    }
                });
            });

            $('.delete-whatsapp-cloud-api').on('click', function() {

                var modal = $('#deleteWhatsappCloudApi');
                modal.find('input[name=id]').val($(this).data('item-id'));
                modal.modal('show');
            });
        });

	})(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.gateway.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/gateway/whatsapp/cloud_api.blade.php ENDPATH**/ ?>