<?php
    $isMembershipPlanActive    = ['admin.membership.plan.*'];
    $isMemberActive            = ['admin.user.*'];
    $isSettingActive           = ['admin.system.*'];
    $isCurrencyActive          = ['admin.system.currency.*'];
    $isLanguageActive          = ['admin.system.language.*'];
    $isSupportTicketActive     = ['admin.support.ticket.*'];
    $isFrontendCustomizeActive = ['admin.frontend.sections.*'];
    $isCreditLogsActive        = ['admin.report.credit.*'];
    $isReportsActive           = ['admin.report.record.*',
                                  'admin.report.payment.detail'];
    $isPaymentActive           = ['admin.payment.*'];
    $isDisapatchGatewayActive  = ['admin.gateway.*'];
    $isTemplateActive          = ['admin.template.*'];
    $isContactActive           = ['admin.contact.*'];
    $isSmsActive               = ['admin.communication.sms.*'];
    $isSmsCampaignActive       = ['admin.communication.sms.campaign.*'];
    $isWhatsappActive          = ['admin.communication.whatsapp.*'];
    $isWhatsappCampaignActive  = ['admin.communication.whatsapp.campaign.*'];
    $isEmailActive             = ['admin.communication.email.*'];
    $isEmailCampaignActive     = ['admin.communication.email.campaign.*'];
    $isBlogActive              = ['admin.blog.api'];
?>

<aside class="sidebar">
    <div class="sidebar-wrapper">
        <div class="sidebar-logo">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="logo">
                <img src="<?php echo e(showImage(config('setting.file_path.panel_logo.path').'/'.site_settings('panel_logo'),config('setting.file_path.panel_logo.size'))); ?>" class="logo-lg" alt="">
                <img src="<?php echo e(showImage(config('setting.file_path.panel_square_logo.path').'/'.site_settings('panel_square_logo'),config('setting.file_path.panel_square_logo.size'))); ?>" class="logo-sm" alt="">
            </a>
            <button class="icon-btn btn-sm dark-soft hover circle d-lg-none" id="sideBar-closer">
                <i class="ri-arrow-left-line"></i>
            </button>
        </div>
        <div class="menu-wrapper">
            <ul class="menus scrollable-menu">

                <li class="menu">
                    <a class="menu-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' :''); ?>" href="<?php echo e(route("admin.dashboard")); ?>">
                        <span class="menu-symbol">
                            <i class="ri-layout-grid-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("dashboard")); ?></span>
                    </a>
                </li>






















































































                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive(array_merge($isSmsActive, $isSmsCampaignActive, $isWhatsappCampaignActive, $isEmailActive, $isWhatsappActive))); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-mail-send-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Messages")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow(array_merge($isSmsActive, $isSmsCampaignActive, $isWhatsappCampaignActive, $isEmailActive, $isWhatsappActive))); ?>" <?php echo e(menuShow(array_merge($isSmsActive, $isWhatsappCampaignActive, $isSmsCampaignActive, $isEmailActive, $isWhatsappActive)) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Communication")); ?></h6>
                            </div>

                            <div class="sidebar-menu-container">
                                <ul class="sidebar-menu">
































































































                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuActive($isWhatsappActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#whatsappCommunication" role="button" aria-expanded="false" aria-controls="whatsappCommunication">
                                        <span>
                                            <i class="ri-whatsapp-line"></i>
                                        </span>
                                        <p> <?php echo e(translate("Whatsapp")); ?> <small>
                                            <i class="ri-arrow-down-s-line"></i>
                                            </small>
                                        </p>
                                        </a>
                                        <div class="side-menu-dropdown collapse <?php echo e(menuShow(array_merge(['admin.communication.whatsapp.create', 'admin.communication.whatsapp.index'], $isWhatsappCampaignActive))); ?>" id="whatsappCommunication">
                                            <ul class="sub-menu">
                                                <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.communication.whatsapp.create') ? 'active' :''); ?>" href="<?php echo e(route('admin.communication.whatsapp.create')); ?>">
                                                    <p><?php echo e(translate("Send Message")); ?></p>
                                                </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.communication.whatsapp.index') ? 'active' :''); ?>" href="<?php echo e(route('admin.communication.whatsapp.index')); ?>">
                                                    <p><?php echo e(translate("History")); ?></p>
                                                </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive($isWhatsappCampaignActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#whatsappCampaign" role="button" aria-expanded="false" aria-controls="whatsappCampaign">

                                                    <p> <?php echo e(translate("Campaign")); ?>

                                                        <small>
                                                        <i class="ri-arrow-down-s-line"></i>
                                                        </small>
                                                    </p>
                                                    </a>
                                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow($isWhatsappCampaignActive)); ?>" id="whatsappCampaign" style="">
                                                    <ul class="sub-menu">
                                                        <li class="sub-menu-item">
                                                            <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.communication.whatsapp.campaign.create') ? 'active' : ''); ?>" href="<?php echo e(route('admin.communication.whatsapp.campaign.create')); ?>">
                                                            <p><?php echo e(translate("Create")); ?></p>
                                                            </a>
                                                        </li>
                                                        <li class="sub-menu-item">
                                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.communication.whatsapp.campaign.index') ? 'active' : ''); ?>" href="<?php echo e(route('admin.communication.whatsapp.campaign.index')); ?>">
                                                            <p><?php echo e(translate("List")); ?></p>
                                                        </a>
                                                        </li>
                                                    </ul>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>

                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive(array_merge($isPaymentActive, $isDisapatchGatewayActive))); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-instance-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Gateway")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow(array_merge($isPaymentActive, $isDisapatchGatewayActive))); ?>" <?php echo e(menuShow(array_merge($isPaymentActive, $isDisapatchGatewayActive)) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Gateway Options")); ?></h6>
                            </div>

                            <div class="sidebar-menu-container">
                                <ul class="sidebar-menu">





























                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuActive($isDisapatchGatewayActive)); ?>"

                                           href="<?php echo e(route("admin.gateway.whatsapp.device")); ?>"
                                        >
                                            <span>
                                                <i class="ri-tools-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Messaging Gateways")); ?></p>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>








































































































































































































































































            </ul>

            <ul class="menus">
                <li class="menu">
                    <a class="menu-link <?php echo e(request()->routeIs('admin.support.*') ? 'active' :''); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-question-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Support")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow($isSupportTicketActive)); ?>" <?php echo e(menuShow($isSupportTicketActive) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Support Ticket")); ?></h6>
                            </div>

                            <div class="sidebar-menu-container">
                                <ul class="sidebar-menu">
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuShow($isSupportTicketActive) != 'show' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#currency" role="button" aria-expanded="false" aria-controls="currencyList">
                                            <span>
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </span>
                                            <p> <?php echo e(translate("All Tickets")); ?> <small> <i class="ri-arrow-down-s-line"></i> </small>
                                            </p>
                                        </a>

                                        <div class="side-menu-dropdown collapse <?php echo e(menuShow($isSupportTicketActive)); ?>" id="currency">
                                            <ul class="sub-menu">
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.support.ticket.index'])); ?>" href="<?php echo e(route('admin.support.ticket.index')); ?>">
                                                        <p><?php echo e(translate("Ticket List")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.support.ticket.priority.high'])); ?>" href="<?php echo e(route('admin.support.ticket.priority.high')); ?>">
                                                        <p><?php echo e(translate("High Priority")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.support.ticket.priority.medium'])); ?>" href="<?php echo e(route('admin.support.ticket.priority.medium')); ?>">
                                                        <p><?php echo e(translate("Medium Priority")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.support.ticket.priority.low'])); ?>" href="<?php echo e(route('admin.support.ticket.priority.low')); ?>">
                                                        <p><?php echo e(translate("Low Priority")); ?></p>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.support.ticket.running') ? 'active' :''); ?>" href="<?php echo e(route('admin.support.ticket.running')); ?>">
                                            <span>
                                                <i class="ri-hourglass-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Running tickets")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.support.ticket.answered') ? 'active' :''); ?>" href="<?php echo e(route('admin.support.ticket.answered')); ?>">
                                            <span>
                                                <i class="ri-question-answer-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Answered tickets")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.support.ticket.replied') ? 'active' :''); ?>" href="<?php echo e(route('admin.support.ticket.replied')); ?>">
                                            <span>
                                                <i class="ri-reply-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Replied tickets")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('admin.support.ticket.closed') ? 'active' :''); ?>" href="<?php echo e(route('admin.support.ticket.closed')); ?>">
                                            <span>
                                                <i class="ri-door-closed-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Closed tickets")); ?></p>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>


                <li class="menu">
                    <a class="menu-link <?php echo e(request()->routeIs('admin.system.*') ? 'active' :''); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-settings-3-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Settings")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow($isSettingActive)); ?>" <?php echo e(menuShow($isSettingActive) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("System Settings")); ?></h6>
                            </div>

                            <div class="sidebar-menu-container">
                                <ul class="sidebar-menu">
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "general" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "general"])); ?>">
                                            <span>
                                                <i class="ri-tools-line"></i>
                                            </span>
                                            <p><?php echo e(translate("General")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "authentication" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "authentication"])); ?>">
                                            <span>
                                                <i class="ri-git-repository-private-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Authentication")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "member" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "member"])); ?>">
                                            <span>
                                                <i class="ri-user-settings-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Member")); ?></p>
                                        </a>
                                    </li>


                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuShow($isCurrencyActive) != 'show' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#currency" role="button" aria-expanded="false" aria-controls="currencyList">
                                            <span>
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </span>
                                            <p> <?php echo e(translate("Currency")); ?> <small> <i class="ri-arrow-down-s-line"></i> </small>
                                            </p>
                                        </a>

                                        <div class="side-menu-dropdown collapse <?php echo e(menuShow($isCurrencyActive)); ?>" id="currency">
                                            <ul class="sub-menu">
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.system.currency.index'])); ?>" href="<?php echo e(route('admin.system.currency.index')); ?>">
                                                        <p><?php echo e(translate("All Currencies")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.system.currency.active'])); ?>" href="<?php echo e(route('admin.system.currency.active')); ?>">
                                                        <p><?php echo e(translate("Active Currencies")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(menuActive(['admin.system.currency.inactive'])); ?>" href="<?php echo e(route('admin.system.currency.inactive')); ?>">
                                                        <p><?php echo e(translate("Inactive Currencies")); ?></p>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>

                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "webhook" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "webhook"])); ?>">
                                            <span>
                                                <i class="ri-webhook-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Webhook")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "recaptcha" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "recaptcha"])); ?>">
                                            <span>
                                                <i class="ri-recycle-line"></i>
                                            </span>
                                            <p><?php echo e(translate("reCAPTCHA")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "social_login" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "social_login"])); ?>">
                                            <span>
                                                <i class="ri-login-box-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Social Login")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "plugin" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "plugin"])); ?>">
                                            <span>
                                                <i class="ri-puzzle-2-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Plugins")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuActive(['admin.system.language.index'])); ?>" href="<?php echo e(route('admin.system.language.index')); ?>">
                                            <span>
                                                <i class="ri-translate-2"></i>
                                            </span>
                                            <p><?php echo e(translate("Language")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(menuActive(['admin.system.spam.word.index'])); ?>" href="<?php echo e(route('admin.system.spam.word.index')); ?>">
                                            <span>
                                                <i class="ri-article-line"></i>
                                            </span>
                                            <p><?php echo e(translate("Spam words")); ?></p>
                                        </a>
                                    </li>
                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->type == "seo" ? 'active' : ''); ?>" href="<?php echo e(route("admin.system.setting", ["type" => "seo"])); ?>">
                                            <span>
                                                <i class="ri-puzzle-2-line"></i>
                                            </span>
                                            <p><?php echo e(translate("SEO Settings")); ?></p>
                                        </a>
                                    </li>

                                    <li class="sidebar-menu-item">
                                        <a class="sidebar-menu-link" href="<?php echo e(route('admin.system.info')); ?>">
                                            <span>
                                                <i class="ri-information-2-line"></i>
                                            </span>
                                            <p><?php echo e(translate("System info")); ?></p>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</aside>
<?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/partials/sidebar.blade.php ENDPATH**/ ?>