<?php

namespace App\Http\Requests;

use App\Enums\ContactAttributeEnum;
use App\Models\GeneralSetting;
use Illuminate\Foundation\Http\FormRequest;

class ContactSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            
            "attribute_name" => "required|regex:/^.*[^0-9].*$/|not_regex:/^\d+$/",
            "attribute_type" => [
                "required",
                "in:".ContactAttributeEnum::DATE->value.
                ','.ContactAttributeEnum::BOOLEAN->value.
                ','.ContactAttributeEnum::NUMBER->value.
                ','.ContactAttributeEnum::TEXT->value
            ]
        ];
        return $rules;
    }
}
