<?php
namespace App\Http\Controllers;

use App\Enums\StatusEnum;
use App\Jobs\UpdateCommunicationLogs;
use App\Jobs\UpdateCreditLogs;
use App\Jobs\UpdateLanguageLogs;
use App\Jobs\UpdateSettings;
use App\Models\CommunicationLog;
use App\Models\CreditLog;
use App\Models\EmailCreditLog;
use App\Models\EmailLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\GeneralSetting;
use App\Models\Language;
use App\Models\SMSlog;
use App\Models\WhatsappCreditLog;
use App\Models\WhatsappDevice;
use App\Models\WhatsappLog;
use App\Service\Admin\Core\SettingService;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;

class UpgradeVersionMigrateController extends Controller
{
    public SettingService $settingService;
    public function __construct(SettingService $settingService) { 

        $this->settingService = $settingService;
    }
    public function index() {
        
        $file_path = base_path('update_info.md');
        $file_contents = [];
        $markdownContent = File::get($file_path);
        $sections = explode('## ', $markdownContent);
        array_shift($sections);
        foreach ($sections as $section) {
            
            $section = trim($section);
            list($section_title, $section_content) = explode("\n", $section, 2);
            $file_contents[$section_title] = $section_content;
        }   

        $general = GeneralSetting::first();
        $current_version = $general->app_version; 
        $new_version     = config('requirements.core.appVersion'); 
        $title = "update $new_version";
        return view('update.index', compact(
            'general',
            'current_version',
            'new_version',
            'title',
            'file_contents'
        ));
    }

    public function update() {
        
        $general         = GeneralSetting::first();
        $current_version = $general->app_version; 
        $new_version     = config('requirements.core.appVersion'); 
        $file_path       = base_path('update_info.md');

        if(version_compare($new_version, $current_version, '>')) {
            
            try {

                $fetch_communication_logs = $this->fetchCommunicationLogs();
                $fetch_languages          = $this->fetchLanguages();
                $fetch_credit_logs        = $this->fetchCreditLogs();
                
                session(["queue_restart" => true]);
                $migrationFiles = [
                   '/database/migrations/2024_05_18_073728_create_notifications_table.php',
                   '/database/migrations/2024_05_22_064038_add_is_default_to_currencies_table.php',
                   '/database/migrations/2024_05_26_094906_create_languages_table.php',
                   '/database/migrations/2024_05_26_095352_create_translations_table.php',
                   '/database/migrations/2024_05_26_131402_create_credit_logs_table.php',
                   '/database/migrations/2024_05_27_073233_modify_users_table.php',
                   '/database/migrations/2024_06_03_090426_modify_contacts_table.php',
                   '/database/migrations/2024_06_05_060741_modify_groups_table.php',
                   '/database/migrations/2024_06_06_051451_create_communication_logs_table.php',
                   '/database/migrations/2024_06_09_145139_modify_pricing_plans_table.php',
                   '/database/migrations/2024_06_27_061803_import_sql_files.php',
                ];
                $dropTableOrColumn = [
                    '/database/migrations/2024_06_26_234404_drop_credit_logs_table.php',
                    '/database/migrations/2024_06_26_234844_drop_campaigns_table.php',
                    '/database/migrations/2024_06_26_235128_drop_templates_table.php',
                    '/database/migrations/2024_06_27_001607_drop_languages_table.php',
                    '/database/migrations/2024_07_04_190216_drop_frontend_sections_table.php',
                    '/database/migrations/2024_07_10_154521_drop_payment_methods_table.php',

                ];
                foreach($dropTableOrColumn as $drop) {

                    Artisan::call('migrate', ['--force' => true, '--path' => $drop ]);
                }
                foreach($migrationFiles as $migrationFile) {

                    Artisan::call('migrate', ['--force' => true, '--path' => $migrationFile ]);
                }  
                
                UpdateCommunicationLogs::dispatch($fetch_communication_logs);
                UpdateLanguageLogs::dispatch($fetch_languages);
                UpdateCreditLogs::dispatch($fetch_credit_logs);

                $settings = [
                    'site_name'                => $general->site_name,
                    'country_code'             => $general->country_code,
                    'contact_meta_data'        => json_decode($general->contact_attributes),
                    'api_sms_method'           => $general->sms_gateway,
                    'email'                    => $general->mail_from,
                    'app_link'                 => $general->app_link,
                    'maintenance_mode_message' => $general->maintenance_mode_message,
                    'whatsapp_word_count'      => $general->whatsapp_word_count,
                    'sms_word_count'           => $general->sms_word_text_count,
                    'sms_word_unicode_count'   => $general->sms_word_unicode_count,
                    'primary_color'            => '#'.$general->primary_color,
                    'secondary_color'          => '#'.$general->secondary_color,
                    'images' => [

                        'site_logo'         => $general->site_logo,
                        'panel_logo'        => $general->panel_logo,
                        'meta_image'        => $general->panel_logo,
                        'favicon'           => $general->favicon,
                        'panel_square_logo' => $general->site_icon,
                        'site_square_logo'  => $general->site_icon,
                    ]
                ];
                foreach ($settings['images'] as $key => $filename) {

                    $filepath = filePath()['site_logo']['path'] .'/'.$filename;
                    
                    if (file_exists($filepath)) {
                        $settings[$key] = new UploadedFile($filepath, $filename);
                    }
                }
                unset($settings['images']);
                // UpdateSettings::dispatch($settings);
                $zipFilePath = storage_path('../../post_update.zip');
                $extractToPath = storage_path("../../"); 

                if (file_exists($zipFilePath)) {
                    $zip = new \ZipArchive;
                    if ($zip->open($zipFilePath) === TRUE) {
                        $zip->extractTo($extractToPath);
                        $zip->close();
                        File::delete($zipFilePath);
                    } else {
                        throw new \Exception('Failed to open the zip file.');
                    }
                }
                if (File::exists($file_path)) {
                
                    File::delete($file_path);
                }
                $zip_vendor = storage_path('../../vendor.zip');
                $extract_vendor = storage_path("../../src/"); 

                if (file_exists($zip_vendor)) {
                    $zip = new \ZipArchive;
                    if ($zip->open($zip_vendor) === TRUE) {
                        $zip->extractTo($extract_vendor);
                        $zip->close();
                        File::delete($zip_vendor);
                    } else {
                        throw new \Exception('Failed to open the zip file.');
                    }
                }
                if (File::exists($file_path)) {
                
                    File::delete($file_path);
                }
                Artisan::call('queue:restart');
                Artisan::call('optimize:clear');
                $notify[] = ['success', 'Succesfully updated database.'];
                return redirect()->to('/')->with('notify', $notify);
                
            } catch(\Exception $e) {
                
                $notify[] = ['error', "Internal Error"];
                return back()->withNotify($notify);
            }
        }

        $notify[] = ['error', "No update needed"];
        return back()->withNotify($notify);
    }
    
    public function versionUpdate($general, $new_version) {
        $current_version      = $new_version;
        $general->app_version = $current_version;
        $general->save();
    }

    public function verify() {
        
        $general         = GeneralSetting::first();
        $current_version = $general->app_version;
        $new_version     = config('requirements.core.appVersion'); 
        $title           = "update $new_version";
        return view('update.verify', compact(
            'general',
            'current_version',
            'new_version',
            'title'
        ));

    }

    public function store(Request $request) {

        $admin_credentials = $request->validate([
            'username' => ['required'],
            'password' => ['required'],
            
        ]);
        $request->validate([
            'purchased_code' => ['required'],
        ]);
        
        try {
            
            if (Auth::guard('admin')->attempt($admin_credentials)) {

                $buyer_domain   = url()->current();
                $purchased_code = $request->purchased_code;
                $response = Http::withoutVerifying()->get('https://license.igensolutionsltd.com', [
                    'buyer_domain'   => $buyer_domain,
                    'purchased_code' => $purchased_code,
                ]);
               
                if($response->json()['status']) {
                    if(File::exists(base_path('update_info.md'))) {
                        Session::put('is_verified', true);
                        $notify[] = ['success', "Verification Successfull"];
                        return redirect()->route('admin.update.index')->withNotify($notify);
                    } 
                    $notify[] = ['error', "Files are not available"];
                    return back()->withNotify($notify); 
                    
                } else {
                    $notify[] = ['error', "Invalid licence key"];
                    return back()->withNotify($notify);
                }
            }
            return back()->withErrors([
                'email' => 'The provided credentials do not match our records.',
            ]);
        } catch(\Exception $e) {
           
            $notify[] = ['info', "Please Try Again"];
            return back()->withNotify($notify);
        }
    }


    // Update Data
    private function fetchCreditLogs() {

        $new_credit_logs = [];
        $sms_credits = CreditLog::all();
        $email_credits = EmailCreditLog::all();
        $whatsapp_credits = WhatsappCreditLog::all();
        $credit_loop = 1;
        foreach($sms_credits as $sms_credit) {

            $new_credit_logs[$credit_loop]['user_id']     = $sms_credit->user_id;
            $new_credit_logs[$credit_loop]['type']        = 1;
            $new_credit_logs[$credit_loop]['manual']      = 0;
            $new_credit_logs[$credit_loop]['trx_number']  = $sms_credit->trx_number;
            $new_credit_logs[$credit_loop]['details']     = $sms_credit->details;
            $new_credit_logs[$credit_loop]['credit_type'] = $sms_credit->credit_type == '+' ? StatusEnum::TRUE->status() : StatusEnum::FALSE->status();
            $new_credit_logs[$credit_loop]['credit']      = $sms_credit->credit;
            $new_credit_logs[$credit_loop]['post_credit'] = $sms_credit->post_credit;
            $new_credit_logs[$credit_loop]['created_at']  = $sms_credit->created_at;
            $new_credit_logs[$credit_loop]['updated_at']  = $sms_credit->updated_at;
            $credit_loop++;
        }
        foreach($email_credits as $email_credit) {

            $new_credit_logs[$credit_loop]['user_id']     = $email_credit->user_id;
            $new_credit_logs[$credit_loop]['type']        = 3;
            $new_credit_logs[$credit_loop]['manual']      = 0;
            $new_credit_logs[$credit_loop]['trx_number']  = $email_credit->trx_number;
            $new_credit_logs[$credit_loop]['details']     =  $email_credit->details;
            $new_credit_logs[$credit_loop]['credit_type'] = $email_credit->credit_type == '+' ? StatusEnum::TRUE->status() : StatusEnum::FALSE->status();
            $new_credit_logs[$credit_loop]['credit']      =  $email_credit->credit;
            $new_credit_logs[$credit_loop]['post_credit'] = $email_credit->post_credit;
            $new_credit_logs[$credit_loop]['created_at']  = $email_credit->created_at;
            $new_credit_logs[$credit_loop]['updated_at']  = $email_credit->updated_at;
            $credit_loop++;
        }
        foreach($whatsapp_credits as $whatsapp_credit) {

            $new_credit_logs[$credit_loop]['user_id']     = $whatsapp_credit->user_id;
            $new_credit_logs[$credit_loop]['type']        = 2;
            $new_credit_logs[$credit_loop]['manual']      = 0;
            $new_credit_logs[$credit_loop]['trx_number']  = $whatsapp_credit->trx_number;
            $new_credit_logs[$credit_loop]['details']     = $whatsapp_credit->details;
            $new_credit_logs[$credit_loop]['credit_type'] = $whatsapp_credit->credit_type == '+' ? StatusEnum::TRUE->status() : StatusEnum::FALSE->status();
            $new_credit_logs[$credit_loop]['credit']      = $whatsapp_credit->credit;
            $new_credit_logs[$credit_loop]['post_credit'] = $whatsapp_credit->post_credit;
            $new_credit_logs[$credit_loop]['created_at']  = $whatsapp_credit->created_at;
            $new_credit_logs[$credit_loop]['updated_at']  = $whatsapp_credit->updated_at;
            $credit_loop++;
        }
        return $new_credit_logs;
        
    }

    private function fetchLanguages() {

        $new_languages = [];
        $languages = Language::all();
        $language_loop = 1;
        foreach($languages as $language) {

            $new_languages[$language_loop]['name']       = $language->name;
            $new_languages[$language_loop]['code']       = $language->code == 'en' ? 'us' : $language->code;
            $new_languages[$language_loop]['is_default'] = $language->is_default == '1' ? StatusEnum::TRUE->status() : StatusEnum::FALSE->status();
            $new_languages[$language_loop]['status']     = StatusEnum::TRUE->status();
            $new_languages[$language_loop]['ltr']        = StatusEnum::FALSE->status();
            $language_loop++;
        }
        return $new_languages;
    }

    private function fetchCommunicationLogs() {

        $new_communication_logs = [];
        $sms_logs = SMSlog::all();
        $email_logs = EmailLog::all();
        $whatsapp_logs = WhatsappLog::all();
        $communication_loop = 1;
        foreach($sms_logs as $sms_log) {

            $new_communication_logs[$communication_loop]['user_id']     = $sms_log->user_id;
            $new_communication_logs[$communication_loop]['contact_id']  = $sms_log->contact_id;
            $new_communication_logs[$communication_loop]['type']        = 1;
            $new_communication_logs[$communication_loop]['gateway_id']  = $sms_log->api_gateway_id;
            $new_communication_logs[$communication_loop]['android_gateway_sim_id'] =  $sms_log->android_gateway_sim_id;
            $new_communication_logs[$communication_loop]['campaign_id'] = $sms_log->campaign_id;
            $new_communication_logs[$communication_loop]['status']      = $sms_log->status;
            $new_communication_logs[$communication_loop]['message']     = ['message_body' => $sms_log->message];
            $new_communication_logs[$communication_loop]['meta_data'] = [

                'contact'      => $sms_log->to,
                'gateway'      => 'N/A',
                'gateway_name' => 'N/A',
                'sms_type'     => $sms_log->sms_type == 2 ? 'unicode' : 'plain',
            ];
            $new_communication_logs[$communication_loop]['response_message'] = $sms_log->response_gateway;
            $new_communication_logs[$communication_loop]['created_at']       = $sms_log->created_at;
            $new_communication_logs[$communication_loop]['updated_at']       = $sms_log->updated_at;
            $communication_loop++;
        }
        foreach($email_logs as $email_log) {

            $new_communication_logs[$communication_loop]['user_id']     = $email_log->user_id;
            $new_communication_logs[$communication_loop]['contact_id']  = $email_log->contact_id;
            $new_communication_logs[$communication_loop]['type']        = 3;
            $new_communication_logs[$communication_loop]['gateway_id']  = $email_log->sender_id;
            $new_communication_logs[$communication_loop]['campaign_id'] = $email_log->campaign_id;
            $new_communication_logs[$communication_loop]['status']      = $email_log->status;
            $new_communication_logs[$communication_loop]['message'] = [

                'subject' => $email_log->subject,
                'message_body' => $email_log->message,
            ];

            $new_communication_logs[$communication_loop]['meta_data'] = [

                'contact'          => $email_log->to,
                'gateway'          => 'N/A',
                'gateway_name'     => 'N/A',
                'gateway_id'       => $email_log->sender_id,
                'email_from_name'  => $email_log->from_name,
                'reply_to_address' => $email_log->reply_to_email,
            ];
            $new_communication_logs[$communication_loop]['response_message'] = $email_log->response_gateway;
            $new_communication_logs[$communication_loop]['created_at']       = $email_log->created_at;
            $new_communication_logs[$communication_loop]['updated_at']       = $email_log->updated_at;
            $communication_loop++;
        }
        foreach($whatsapp_logs as $whatsapp_log) {

            $new_communication_logs[$communication_loop]['user_id']     = $whatsapp_log->user_id;
            $new_communication_logs[$communication_loop]['contact_id']  = $whatsapp_log->contact_id;
            $new_communication_logs[$communication_loop]['type']        = 2;
            $new_communication_logs[$communication_loop]['gateway_id']  = $whatsapp_log->whatsapp_id;
            $new_communication_logs[$communication_loop]['whatsapp_template_id'] = $whatsapp_log->template_id;
            $new_communication_logs[$communication_loop]['file_info']   = $whatsapp_log->file_info;
            $new_communication_logs[$communication_loop]['campaign_id'] = $whatsapp_log->campaign_id;
            $new_communication_logs[$communication_loop]['status']      = $whatsapp_log->status;
            $new_communication_logs[$communication_loop]['message'] = [
                
                'message_body'     => $whatsapp_log->message,
                'message_response' => $whatsapp_log->message_response
            ];
            $new_communication_logs[$communication_loop]['meta_data'] = [

                'contact'      => $whatsapp_log->to,
                'gateway'      => 'N/A',
                'gateway_name' => 'N/A',
            ];
            $new_communication_logs[$communication_loop]['response_message'] = $whatsapp_log->response_gateway;
            $new_communication_logs[$communication_loop]['created_at']       = $whatsapp_log->created_at;
            $new_communication_logs[$communication_loop]['updated_at']       = $whatsapp_log->updated_at;
            $communication_loop++;
        }
        return $new_communication_logs;
    }

    private function updateCommunicationLog($fetch_communication_logs) {

        foreach($fetch_communication_logs as $communication_log) {

            CommunicationLog::create($communication_log);
        }
    }

    private function updateLanguagelog($fetch_languages) {

        foreach($fetch_languages as $language_log) {

            Language::create($language_log);
        }
    }

    private function updateCreditLogs($fetch_credit_logs) {

        foreach($fetch_credit_logs as $credit_log) {

            CreditLog::create($credit_log);
        }
    }
}
