var io = require("socket.io-client");
const other_server = io.connect('https://dayminer.herokuapp.com', {
    forceJSONP: true,
    allowEIO3: false,
    transports: ['websocket']
});

let options = {
    roll: 'P',
    subs: ['wsb', 'investing', 'pennystocks', 'robinhood', 'daytrading', 'stocks', 'options', 'thewallstreet', 'stockmarket', 'securityanalysis'],
    sort: 'score',
    dark: false,
    redditVersion: 'old'
}
other_server.on("connect_error", (err) => {
    console.log(err)
    console.log(`connect_error due to ${err}`);
});
// other_server.on('sendData', function (data) {
//     data = JSON.parse(data);
//     dayminer.saveData(data)
// });

other_server.on('connect', function () {
//    console.log("Socket connection");
});


const dayminer = {
    getData: async () => {
        other_server.emit('reqData', options);
    }
}

function changeSort(tickers) {
    let algo = 'score';

    if (algo === 'score') {
        const tempData = tickers.sort((a, b) => { // sort by score 
            return b.score - a.score
        })
        tickers = tempData
    }
    return tickers;
}
module.exports = (app) => {
    return {
        getData: dayminer.getData,
        saveData: async () => {
            other_server.on('sendData', function (data) {
                let allData = JSON.parse(data);

                let tempTickers = [];
                let tickers = [];

                if (allData.wsb && allData.wsb[0]) {
                    // console.log('incl wsb')
                    allData.wsb.map((item1) => { // item1 = wsb15[0]
                        let tickerIndex = tempTickers.findIndex(item2 => item2.tickerSymbol === item1.tickerSymbol)
                        if (tickerIndex === -1) { // Did not find ticker
                            tempTickers.push(item1)
                        } else {
                            tempTickers[tickerIndex].change = item1.change + tempTickers[tickerIndex].change
                            item1.content.map(item2 => { // item2 = wsb[0].content
                                let contentIndex = tempTickers[tickerIndex].content.findIndex(item3 => item2.id === item3.id)
                                if (contentIndex === -1) { // found ticker but not content 
                                    tempTickers[tickerIndex].content.push(item2)
                                }
                            })
                        }
                    });

                    // should build in temp and return clean 
                    tempTickers.map((item1) => {
                        let accum = 0
                        if (item1.content) {
                            item1.content.map((item2) => {
                                if (item2.score > 0) { // prevent negative scores from impacting too much, discussion is still happening 
                                    accum = accum + item2.score
                                }
                                // console.log(`updated '${item1.tickerSymbol}' from ${item1.count} to ${accum}`)
                                item1.score = accum
                            })
                        }
                        tickers.push({ symbol: item1.tickerSymbol, score: item1.score })
                    })

                    tickers = changeSort(tickers); // sort by score
                    tickers = tickers.splice(0, 50); // Get 50 records
                    app.model.dayminer.insert(tickers);
                }
            });
        }
    }
}