<!-- resources/views/git/index.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sats-Ketchup Loding</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700;900&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('toaster/styles.css') }}" />
    <link rel="stylesheet" href="{{ asset('css/dropdown.css') }}" />
    <link rel="stylesheet" href="{{ asset('style.css') }}" />
</head>
<body>
<div id="container">
    <div id="sidebar">
        <div id="repo-header">
            <div class="repo-header-logo">
                <img src="{{ asset('files/Sats_Logo_small.png') }}" alt="Logo" id="repo-logo" />
            </div>
            <div class="repo-header-title">
                <h1>Sats-Ketchup</h1>
            </div>
            <div id="repo-info">
                <span class="public-status">Public</span>
            </div>
        </div>
        <hr />

        <div class="git-layout-wrapper">
            <div class="git-header-wrapper">
                <div class="git-header-layout">
                    <div class="git-header-left-content">
                        <div class="git-branch-switcher">
                            <div class="git-dropdown-layout">
                                <div class="dropdown">
                                    <button class="dropdown-btn" onclick="toggleDropdown()">
                                        <img src="/assets/code-branch.png" />
                                        <span id="current-branch-text" class="dropdown-btn-text">repo</span>
                                        <img src="/assets/sort-down.png" />
                                    </button>
                                    <div class="dropdown-content" id="dropdownContent">
                                        <div class="tabs">
                                            <div class="tab active" onclick="switchTab('branches')">Branches</div>
                                            <div class="tab" onclick="switchTab('tags')">Tags</div>
                                        </div>
                                        <div class="search-bar">
                                            <input type="text" id="searchInput" placeholder="Find or create a branch..." onkeyup="filterList()" />
                                        </div>
                                        <div id="branchList" class="list"></div>
                                        <div id="tagList" class="list" style="display: none"></div>
                                        <div class="view-all" id="viewAllText">View all Branches</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="git-branch-count">
                            <div class="git-c-layout">
                                <div class="git-c-icon">
                                    <img src="/assets/code-branch.png" />
                                </div>
                                <div class="git-c-label">
                                    <label><span>0</span> branch</label>
                                </div>
                            </div>
                        </div>
                        <div class="git-tags-count">
                            <div class="git-c-layout">
                                <div class="git-c-icon">
                                    <img src="/assets/tag.png" />
                                </div>
                                <div class="git-c-label">
                                    <label><span>0</span> tags</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="git-header-right-content">
                        <div class="git-url-link">
                            <button class="github-button" id="githubButton" onclick="copyLink()">
                                <img src="/assets/github.png" alt="GitHub Logo" />
                                GitHub
                                <img src="/assets/link.png" alt="Link Icon" />
                            </button>
                            <div class="copied-message hidden" id="copiedMessage">Link Copied</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="git-body-wrapper">
                <div class="git-body-header">
                    <div class="header-left">
                        <img src="/assets/avatar.png" alt="User Avatar" id="author-avatar" />
                        <span id="author-name">author</span>
                        <span class="commit-message">Last Message</span>
                    </div>
                    <div class="header-right">
                        <label><span>TimeStamp</span></label>
                        <span><img src="/assets/history.png" />
                            <span id="commitCount" style="padding-right: 3px">0</span> Commits</span>
                    </div>
                </div>
                <div class="file-list" id="fileList"></div>
                <div class="loader-placeholder">
                    <div class="loader-content">
                        <span class="loader"></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="resizer"></div>

    <div class="content">
        <h2 class="top-heading">File Content <span id="read-file-name"></span></h2>
        <pre id="file-content">Select a file to view its content.</pre>
        <img id="file-image" class="hidden" alt="Image Preview" />
    </div>
</div>

<script src="{{ asset('jquery.min.js') }}"></script>
<script src="{{ asset('toaster/toast-plugin-min.js') }}"></script>
<script src="{{ asset('script.js') }}"></script>
<script src="{{ asset('js/gitdropdown.js') }}"></script>
<script>
    window.onload = () => {
        fetchRepoStructure();  // Call this function when the page is loaded
    };

    async function fetchRepoStructure() {
        const owner = "mashhoodrehman";
        const repo = "stock";
        const branch = "master";

        try {
            const response = await fetch(`/repo?owner=${owner}&repo=${repo}&branch=${branch}`);
            const data = await response.json();

            if (data.error) {
                console.error("GitHub API Error:", data.message);
                return;
            }

            console.log("Repo contents:", data);
            displayFiles(data); // Your custom UI rendering logic
        } catch (error) {
            console.error("Request error:", error);
        }
    }

    function displayFiles(files) {
        const fileListElement = document.getElementById("fileList");
        fileListElement.innerHTML = ""; // Clear previous content

        files.forEach(file => {
            const fileItem = document.createElement("div");
            fileItem.classList.add("file");

            const icon = file.type === "dir" ? "📁" : "📄"; // Folder or File icon
            fileItem.innerHTML = `${icon} ${file.name}`;

            fileItem.onclick = () => {
                if (file.type === "dir") {
                    // Open folder recursively
                    fetchRepoStructure(file.path); // Pass the folder path if you want deeper structure
                } else {
                    // Show file content (for example, if it's a code file or text)
                    loadFileContent(file.download_url);
                }
            };

            fileListElement.appendChild(fileItem);
        });
    }
</script>

</body>
</html>
