<!-- resources/views/git/index.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Sats-Ketchup Loding</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap"
      rel="stylesheet"
    />
    <link rel="stylesheet" type="text/css" href="{{asset('toaster/styles.css')}}" />
    <link rel="stylesheet" href="{{asset('css/dropdown.css')}}" />
    <link rel="stylesheet" href="{{asset('style.css')}}" />
  </head>
<body>
<div id="container">
    <div id="sidebar">
        <div id="repo-header">
          <div class="repo-header-logo">
            <img src="files/Sats_Logo_small.png" alt="Logo" id="repo-logo" />
          </div>
          <div class="repo-header-title">
            <h1>Sats-Ketchup</h1>
          </div>
          <div id="repo-info">
            <span class="public-status">Public</span>
          </div>
        </div>
        <hr />

        <div class="git-layout-wrapper">
          <div class="git-header-wrapper">
            <div class="git-header-layout">
              <div class="git-header-left-content">
                <div class="git-branch-switcher">
                  <div class="git-dropdown-layout">
                    <div class="dropdown">
                      <button class="dropdown-btn" onclick="toggleDropdown()">
                        <img src="{{asset('assets/code-branch.png')}}" />
                        <span id="current-branch-text" class="dropdown-btn-text"
                          >repo</span
                        ><img src="{{asset('assets/sort-down.png')}}" />
                      </button>
                      <div class="dropdown-content" id="dropdownContent">
                        <div class="tabs">
                          <div
                            class="tab active"
                            onclick="switchTab('branches')"
                          >
                            Branches
                          </div>
                          <div class="tab" onclick="switchTab('tags')">
                            Tags
                          </div>
                        </div>
                        <div class="search-bar">
                          <input
                            type="text"
                            id="searchInput"
                            placeholder="Find or create a branch..."
                            onkeyup="filterList()"
                          />
                        </div>
                        <div id="branchList" class="list"></div>
                        <div
                          id="tagList"
                          class="list"
                          style="display: none"
                        ></div>
                        <div class="view-all" id="viewAllText">
                          View all Branches
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="git-branch-count">
                  <div class="git-c-layout">
                    <div class="git-c-icon">
                      <img src="{{asset('assets/code-branch.png')}}" />
                    </div>
                    <div class="git-c-label">
                      <label><span>0</span> branch</label>
                    </div>
                  </div>
                </div>
                <div class="git-tags-count">
                  <div class="git-c-layout">
                    <div class="git-c-icon">
                      <img src="{{asset('assets/tag.png')}}" />
                    </div>
                    <div class="git-c-label">
                      <label><span>0</span> tags</label>
                    </div>
                  </div>
                </div>
              </div>
              <div class="git-header-right-content">
                <div class="git-url-link">
                  <button
                    class="github-button"
                    id="githubButton"
                    onclick="copyLink()"
                  >
                    <img src="{{asset('assets/github.png')}}" alt="GitHub Logo" />
                    GitHub
                    <img src="{{asset('assets/link.png')}}" alt="Link Icon" />
                  </button>
                  <div class="copied-message hidden" id="copiedMessage">
                    Link Copied
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="git-body-wrapper">
            <div class="git-body-header">
              <div class="header-left">
                <img
                  src="{{asset('assets/avatar.png')}}"
                  alt="User Avatar"
                  id="author-avatar"
                />
                <span id="author-name">authur</span>
                <span class="commit-message">Last Message</span>
              </div>
              <div class="header-right">
                <label><span>TimeStamp</span></label>
                <span
                  ><img src="{{asset('assets/history.png')}}" />
                  <span id="commitCount" style="padding-right: 3px">0</span>
                  Commits</span
                >
              </div>
            </div>
            <div class="file-list" id="fileList"></div>
            <div class="loader-placeholder">
              <div class="loader-content">
                <span class="loader"></span>
              </div>
            </div>
          </div>
        </div>
      </div>

    <div class="content" style="padding: 20px;">
        <h2>📁 File Content <span id="read-file-name"></span></h2>
        <p><strong>Last Commit:</strong> <span id="commit-message">-</span></p>
        <p><strong>Commit Date:</strong> <span id="commit-date">-</span></p>
        <pre id="file-content" style="background: #f0f0f0; padding: 10px;">Select a file to view its content.</pre>
    </div>
</div>


<script>
    const fetchRepoStructure = async (path = '') => {
        showLoader();
        const res = await fetch(`/public/repo?path=${path}`);
        const data = await res.json();
        if(data.repoStructure){
            displayFiles(data.repoStructure);
        }
        hideLoader();
    };
const displayFiles = (files) => {
    const fileList = document.getElementById("fileList");
    fileList.innerHTML = ""; // Clear previous content

    let currentFolder = files;
    let navigationStack = [];

    // Function to render the file and folder structure
    const renderFiles = (files, folderName = null) => {
        fileList.innerHTML = "";

        // Back button for navigation
        if (navigationStack.length > 0) {
            const backButton = document.createElement("div");
            backButton.classList.add("back-button");
            backButton.innerHTML = `
                <img src="assets/folder.png" width="18"> 
                <span style="position: relative; top: 3px;">
                    <img src="assets/left-arrow.png" width="18">
                </span>`;
            backButton.onclick = goBack;
            fileList.appendChild(backButton);
        }

        // Create a container for files
        const fileContainer = document.createElement("div");
        fileContainer.classList.add("file-container");

        files.forEach((file) => {
            const row = document.createElement("div");
            row.className = "file-row";
            row.style.display = "flex";
            row.style.justifyContent = "space-between";
            row.style.borderBottom = "1px solid #ddd";
            row.style.padding = "8px";
            row.style.cursor = "pointer";

            // Left part of the row
            const left = document.createElement("div");
            const iconSrc = file.type === "dir" ? "assets/folder.png" : "assets/document.png";  // Folder or File icon
            left.innerHTML = `<img src="${iconSrc}" width="18"><span>${file.name}</span>`;

            // Right part of the row (Commit message loader for files)
            const right = document.createElement("div");
            right.innerHTML = file.type === "file" ? `<span class="commit-loader">Loading commit...</span>` : "";

            row.appendChild(left);
            row.appendChild(right);

            // Handle click events
            row.onclick = () => {
                if (file.type === "dir") {
                    openFolder(file); // Open sub-folder
                } else {
                    loadFileContent(file.download_url, file.path); // Load file content
                }
            };

            fileContainer.appendChild(row);

            // Fetch commit for files
            if (file.type === "file") {
                fetchCommitForFile(file.path, right);
            }
        });

        fileList.appendChild(fileContainer);
    };

    // Function to open a folder and push the current folder into the navigation stack
    const openFolder = (folder) => {
        navigationStack.push(currentFolder);
        currentFolder = folder.children;
        renderFiles(folder.children, folder.name);
    };

    // Function to go back to the previous folder
    const goBack = () => {
        if (navigationStack.length > 0) {
            currentFolder = navigationStack.pop();
            renderFiles(currentFolder);
        }
    };

    // Initial rendering of the files
    renderFiles(files);
};


// const fetchCommitForFile = async (path, element) => {
//         const res = await fetch(`/public/commits?path=${encodeURIComponent(path)}`);
//         const commitData = await res.json();

//         if(commitData.message){
//             element.innerHTML = `
//                 <div style="font-size:12px;font-weight:bold;">${commitData.message}</div>
//                 <div style="font-size:11px;color:gray;">${new Date(commitData.date).toLocaleString()}</div>
//             `;
//         }else{
//             element.textContent = "No commits";
//         }
//     };

// Helper function to fetch the commit for each file
const fetchCommitForFile = async (filePath, rightContainer) => {
    try {
        const response = await fetch(`/public/commits?path=${encodeURIComponent(filePath)}`);
        const commitData = await response.json();

        if (commitData && commitData.message && commitData.date) {
            const commitDate = timeAgo(commitData.date);  // Format the timestamp
            rightContainer.innerHTML = `
                <span class="commit-msg">${commitData.message}</span>
                <span class="commit-date">${commitDate}</span>
            `;
        } else {
            rightContainer.innerHTML = "<span>No commit message or date available</span>";
        }
    } catch (error) {
        console.error("Error fetching commit for file:", error);
        rightContainer.innerHTML = "<span>Failed to load commit message</span>";
    }
};

const timeAgo = (timestamp) => {
    const now = new Date();
    const diffInSeconds = (now - new Date(timestamp)) / 1000;
    const diffInMinutes = diffInSeconds / 60;
    const diffInHours = diffInMinutes / 60;
    const diffInDays = diffInHours / 24;
    const diffInMonths = diffInDays / 30;
    const diffInYears = diffInMonths / 12;

    if (diffInSeconds < 60) {
        return "Just now";
    } else if (diffInMinutes < 60) {
        return `${Math.floor(diffInMinutes)} min ago`;
    } else if (diffInHours < 24) {
        return `${Math.floor(diffInHours)} hours ago`;
    } else if (diffInDays < 30) {
        return `${Math.floor(diffInDays)} days ago`;
    } else if (diffInMonths < 12) {
        return `${Math.floor(diffInMonths)} months ago`;
    } else {
        return `${Math.floor(diffInYears)} years ago`;
    }
};



// Helper function to load file content
const loadFileContent = (downloadUrl, filePath) => {
    const contentEl = document.getElementById("file-content");
    const imgEl = document.getElementById("file-image");
    contentEl.textContent = "Loading...";
    imgEl.classList.add("hidden");
    document.getElementById("read-file-name").textContent = filePath;

    fetch(downloadUrl)
        .then(res => res.blob())
        .then(blob => {
            const fileExt = filePath.split('.').pop().toLowerCase();
            if (fileExt === 'pdf') {
                contentEl.innerHTML = `<iframe src="${URL.createObjectURL(blob)}" width="100%" height="600px"></iframe>`;
                imgEl.classList.add("hidden");
            } else {
                imgEl.src = URL.createObjectURL(blob);
                imgEl.classList.remove("hidden");
                contentEl.textContent = "";
            }
        })
        .catch(error => {
            console.error("Error loading file content:", error);
            contentEl.textContent = "Error loading file.";
        });
};




    const showLoader = () => document.querySelector(".loader-placeholder").style.display = "flex";
    const hideLoader = () => document.querySelector(".loader-placeholder").style.display = "none";

    window.onload = () => {
        fetchRepoStructure();
    };
</script>


<script>
    const base_url = 'https://api.github.com';
    const token = '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'; // move to env in production

    const showLoader = () => {
        document.querySelector(".loader-placeholder").style.display = "flex";
    };

    const hideLoader = () => {
        document.querySelector(".loader-placeholder").style.display = "none";
    };

    
    
</script>

<style>
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        display: flex;
        height: 100vh;
    }

    #container {
        display: flex;
        width: 100%;
    }

    #sidebar {
        width: 300px;
        border-right: 1px solid #ddd;
        background: #fafafa;
        overflow-y: auto;
    }

    .content {
        flex: 1;
        overflow-y: auto;
    }

    .loader-placeholder {
        display: none;
        justify-content: center;
        align-items: center;
        padding: 10px;
    }

    .loader {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #3498db;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg);}
        100% { transform: rotate(360deg);}
    }
</style>
</body>
</html>
