<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class GitController extends Controller
{
    public function index()
    {
        return view('repo');
    }

  public function getRepoStructure(Request $request)
    {
        $owner  = 'mashhoodrehman';
        $repo   = 'reactbuild';
        $branch = 'master';
        $path   = $request->get('path');

        $token  = "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"; // For production, move to .env file

        if (!$token) {
            return response()->json(['error' => 'GitHub token not configured.'], 500);
        }

        $url = !empty($path)
            ? "https://api.github.com/repos/{$owner}/{$repo}/contents/{$path}?ref={$branch}"
            : "https://api.github.com/repos/{$owner}/{$repo}/contents/?ref={$branch}";

        $response = Http::withToken($token)->get($url);

        if ($response->failed()) {
            return response()->json([
                'error' => 'Failed to fetch repo contents.',
                'status' => $response->status(),
                'message' => $response->json()
            ], $response->status());
        }

        $repoStructure = $response->json();

        return response()->json([
            'repoStructure' => $repoStructure,
            'branchName' => $branch,
            'githubLink' => "https://github.com/{$owner}/{$repo}"
        ]);
    }
    
    public function getFileCommit(Request $request)
{
    $owner  = 'mashhoodrehman';
    $repo   = 'reactbuild';
    $branch = 'master';
    $path   = $request->get('path');

    $token  = "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"; // Secure token via .env

    if (!$token || !$path) {
        return response()->json(['error' => 'Missing token or file path'], 400);
    }

    $commitUrl = "https://api.github.com/repos/{$owner}/{$repo}/commits?path={$path}&sha={$branch}&per_page=1";
    $commitResponse = Http::withToken($token)->get($commitUrl);

    if ($commitResponse->failed()) {
        return response()->json(['error' => 'Failed to fetch commit'], 500);
    }

    $data = $commitResponse->json();

    if (!empty($data[0])) {
        return response()->json([
            'message' => $data[0]['commit']['message'],
            'author' => $data[0]['commit']['author']['name'],
            'date' => $data[0]['commit']['author']['date']
        ]);
    }

    return response()->json(['message' => 'No commits found'], 404);
}

public function getFileCommits(Request $request)
{
    $owner  = 'mashhoodrehman';
    $repo   = 'reactbuild';
    $branch = 'master';
    $path   = $request->get('path');

    if (!$path) {
        return response()->json(['error' => 'File path required'], 400);
    }

    $token = "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";

    $commitUrl = "https://api.github.com/repos/{$owner}/{$repo}/commits?path={$path}&sha={$branch}&per_page=1";
    $commitResponse = Http::withToken($token)->get($commitUrl);

    if ($commitResponse->failed()) {
        return response()->json(['error' => 'Failed to fetch commit details'], $commitResponse->status());
    }

    $commits = $commitResponse->json();

    if (!empty($commits)) {
        return response()->json([
            'message' => $commits[0]['commit']['message'],
            'date' => $commits[0]['commit']['author']['date']
        ]);
    }

    return response()->json(['message' => 'No commits found', 'date' => null]);
}


}

