const mongoose = require('mongoose');


module.exports = (app) => {

    console.log("Database : " + app.config.database.db);
    const uri = `mongodb+srv://${app.config.database.options.user}:${app.config.database.options.pass}@${app.config.database.host}/${app.config.database.db}?retryWrites=true&w=majority`;

    mongoose.connect(uri, app.config.database.options);
    mongoose.set('debug', true);
    const dbSchema = require("./schema");

    return Object.freeze({
        dayminer: mongoose.model('dayminers', dbSchema.dayminer()),
    })

}
