<!-- resources/views/git/index.blade.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Sats-Ketchup Loding</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap"
      rel="stylesheet"
    />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('toaster/styles.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('css/dropdown.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('style.css')); ?>" />
  </head>
<body>
<div id="container">
    <div id="sidebar">
        <div id="repo-header">
          <div class="repo-header-logo">
            <img src="files/Sats_Logo_small.png" alt="Logo" id="repo-logo" />
          </div>
          <div class="repo-header-title">
            <h1>Sats-Ketchup</h1>
          </div>
          <div id="repo-info">
            <span class="public-status">Public</span>
          </div>
        </div>
        <hr />

        <div class="git-layout-wrapper">
          <div class="git-header-wrapper">
            <div class="git-header-layout">
              <div class="git-header-left-content">
                <div class="git-branch-switcher">
                  <div class="git-dropdown-layout">
                    <div class="dropdown">
                      <button class="dropdown-btn" onclick="toggleDropdown()">
                        <img src="<?php echo e(asset('assets/code-branch.png')); ?>" />
                        <span id="current-branch-text" class="dropdown-btn-text"
                          >repo</span
                        ><img src="<?php echo e(asset('assets/sort-down.png')); ?>" />
                      </button>
                      <div class="dropdown-content" id="dropdownContent">
                        <div class="tabs">
                          <div
                            class="tab active"
                            onclick="switchTab('branches')"
                          >
                            Branches
                          </div>
                          <div class="tab" onclick="switchTab('tags')">
                            Tags
                          </div>
                        </div>
                        <div class="search-bar">
                          <input
                            type="text"
                            id="searchInput"
                            placeholder="Find or create a branch..."
                            onkeyup="filterList()"
                          />
                        </div>
                        <div id="branchList" class="list"></div>
                        <div
                          id="tagList"
                          class="list"
                          style="display: none"
                        ></div>
                        <div class="view-all" id="viewAllText">
                          View all Branches
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="git-branch-count">
                  <div class="git-c-layout">
                    <div class="git-c-icon">
                      <img src="<?php echo e(asset('assets/code-branch.png')); ?>" />
                    </div>
                    <div class="git-c-label">
                      <label><span>0</span> branch</label>
                    </div>
                  </div>
                </div>
                <div class="git-tags-count">
                  <div class="git-c-layout">
                    <div class="git-c-icon">
                      <img src="<?php echo e(asset('assets/tag.png')); ?>" />
                    </div>
                    <div class="git-c-label">
                      <label><span>0</span> tags</label>
                    </div>
                  </div>
                </div>
              </div>
              <div class="git-header-right-content">
                <div class="git-url-link">
                  <button
                    class="github-button"
                    id="githubButton"
                    onclick="copyLink()"
                  >
                    <img src="<?php echo e(asset('assets/github.png')); ?>" alt="GitHub Logo" />
                    GitHub
                    <img src="<?php echo e(asset('assets/link.png')); ?>" alt="Link Icon" />
                  </button>
                  <div class="copied-message hidden" id="copiedMessage">
                    Link Copied
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="git-body-wrapper">
            <div class="git-body-header">
  <div class="header-left">
    <img src="<?php echo e(asset('public/assets/avatar.png')); ?>" alt="User Avatar" id="author-avatar">
    <span id="author-name">author</span>  <!-- Author Name -->
    <span class="commit-message">Last Message</span>  <!-- Last Commit Message -->
  </div>
  <div class="header-right">
    <label><span>TimeStamp</span></label>
    <span>
      <img src="<?php echo e(asset('assets/history.png')); ?>">
      <span id="commitCount" style="padding-right: 3px">0</span> Commits
    </span>
  </div>
</div>
            <div class="file-list" id="fileList"></div>
            <div class="loader-placeholder">
              <div class="loader-content">
                <span class="loader"></span>
              </div>
            </div>
          </div>
        </div>
      </div>

    <div class="content" style="padding: 20px;">
        <h2>📁 File Content <span id="read-file-name"></span></h2>
        <p><strong>Last Commit:</strong> <span id="commit-message">-</span></p>
        <p><strong>Commit Date:</strong> <span id="commit-date">-</span></p>
        <pre id="file-content" style="background: #f0f0f0; padding: 10px;">Select a file to view its content.</pre>
        <img id="file-image" class="hidden" alt="Image Preview" />
    </div>
</div>


<script>
   // Function to fetch the repository structure based on the given path
const fetchRepoStructure = async (path = '' , branch='') => {
    showLoader();
    const res = await fetch(`/public/repo?path=${path}&branch`);
    const data = await res.json();
    
    // If we have a valid repo structure, render the files
    if(data.repoStructure){
        displayFiles(data.repoStructure);
    }
    hideLoader();
};

const displayFiles = (files) => {
    const fileList = document.getElementById("fileList");
    fileList.innerHTML = ""; // Clear previous content

    let currentFolder = files;
    let navigationStack = []; // Stack to keep track of navigation history

    // Function to render the file and folder structure
  const renderFiles = (files) => {
    const fileList = document.getElementById("fileList");
    fileList.innerHTML = "";  // Clear previous content

    // Back button for navigation (only appears when there are previous directories in the stack)
    if (navigationStack.length > 0) {
        const backButton = document.createElement("div");
        backButton.classList.add("back-button");
        backButton.innerHTML = `
            <img src="assets/folder.png" width="18"> 
            <span style="position: relative; top: 3px;">
                <img src="assets/left-arrow.png" width="18">
            </span>`;
        backButton.onclick = goBack; // Attach goBack function to back button
        fileList.appendChild(backButton); // Add the back button to the list
    }

    const fileContainer = document.createElement("div");
    fileContainer.classList.add("file-container");

    files.forEach((file) => {
        const row = document.createElement("div");
        row.className = "file-row";
        row.style.display = "flex";
        row.style.justifyContent = "space-between";
        row.style.borderBottom = "1px solid #ddd";
        row.style.padding = "8px";
        row.style.cursor = "pointer";

        const left = document.createElement("div");
        const iconSrc = file.type === "dir" ? "assets/folder.png" : "assets/document.png";  // Folder or File icon
        left.innerHTML = `<img src="${iconSrc}" width="18"><span>${file.name}</span>`;

        const right = document.createElement("div");
        right.innerHTML = file.type === "file" ? `<span class="commit-loader">Loading commit...</span>` : "";

        row.appendChild(left);
        row.appendChild(right);

        row.onclick = () => {
            if (file.type === "dir") {
                openFolder(file); // Open sub-folder and fetch its content
            } else {
                console.log(file , 'file')
                loadFileContent(file.path); // Load file content
            }
        };

        fileContainer.appendChild(row);

        // Fetch commit for files (if it's a file type)
        if (file.type === "file") {
            fetchCommitForFile(file.path, right);
        }
    });

    fileList.appendChild(fileContainer);
};

    // Function to open a folder and fetch its structure based on the folder path
   // Function to open a folder and push the current folder into the navigation stack
const openFolder = (folder) => {
    // Push the current folder into the stack for "back" functionality
    navigationStack.push(currentFolder);

    // Set the new current folder to be the children of the clicked folder
    currentFolder = folder.children;

    // Fetch the structure of the clicked folder
    fetchRepoStructure(folder.path  , "");  // Assuming 'folder.path' holds the path of the clicked folder

    // Render the files and subdirectories of the selected folder
    renderFiles(currentFolder);
};


    // Function to go back to the previous folder
   // Function to go back to the previous folder (parent directory)
const goBack = () => {
    if (navigationStack.length > 0) {
        // Pop the last folder from the stack
        currentFolder = navigationStack.pop();

        // Render the previous folder's contents
        renderFiles(currentFolder);
    }
};


    // Initial rendering of the files
    renderFiles(files);
};

// Helper function to fetch the commit for each file
const fetchCommitForFile = async (filePath, rightContainer) => {
    try {
        const response = await fetch(`/public/commits?path=${encodeURIComponent(filePath)}`);
        const commitData = await response.json();

        if (commitData && commitData.message && commitData.date) {
            const commitDate = timeAgo(commitData.date);  // Format the timestamp
            rightContainer.innerHTML = `
                <span class="commit-msg">${commitData.message}</span>
                <span class="commit-date">${commitDate}</span>
            `;
        } else {
            rightContainer.innerHTML = "<span>No commit message or date available</span>";
        }
    } catch (error) {
        console.error("Error fetching commit for file:", error);
        rightContainer.innerHTML = "<span>Failed to load commit message</span>";
    }
};




// const fetchCommitForFile = async (path, element) => {
//         const res = await fetch(`/public/commits?path=${encodeURIComponent(path)}`);
//         const commitData = await res.json();

//         if(commitData.message){
//             element.innerHTML = `
//                 <div style="font-size:12px;font-weight:bold;">${commitData.message}</div>
//                 <div style="font-size:11px;color:gray;">${new Date(commitData.date).toLocaleString()}</div>
//             `;
//         }else{
//             element.textContent = "No commits";
//         }
//     };




// Helper function to load file content
const loadFileContent = (filePath) => {
    const contentEl = document.getElementById("file-content");
    const imgEl = document.getElementById("file-image");
    
    if (!contentEl) {
        console.error("Error: 'file-content' element not found.");
        return;
    }
    
    if (!imgEl) {
        console.error("Error: 'file-image' element not found.");
        return;
    }

    // Show loading state
    contentEl.textContent = "Loading...";
    imgEl.classList.add("hidden");
    document.getElementById("read-file-name").textContent = filePath;

    // Replace with your backend API endpoint for fetching file information
    fetch(`/public/file?path=${filePath}`)
        .then(res => res.json())
        .then(fileData => {
            // Assuming fileData contains the content, type, and other metadata
            const fileExt = fileData.fileName.split('.').pop().toLowerCase();
            
            // Display the content depending on file type (text, PDF, image, etc.)
            if (fileExt === 'pdf') {
                contentEl.innerHTML = `<iframe src="${fileData.contentUrl}" width="100%" height="600px"></iframe>`;
                imgEl.classList.add("hidden");
            } else if (fileExt === 'jpg' || fileExt === 'jpeg' || fileExt === 'png' || fileExt === 'gif') {
                // Show image for image files
                imgEl.src = fileData.contentUrl;  // Assuming `contentUrl` contains the URL to the image
                imgEl.classList.remove("hidden");
                contentEl.textContent = "";
            } else {
                // Display other file content (text files, for example)
                contentEl.textContent = fileData.fileContent;  // Display content for text files
                imgEl.classList.add("hidden");
            }
        })
        .catch(error => {
            console.error("Error loading file content:", error);
            contentEl.textContent = "Error loading file.";
        });
};





    let currentBranch = 'master';  // Default branch

// Fetch all branches of the repository and populate the dropdown
const fetchBranches = async () => {
    showLoader();
    try {
        const res = await fetch('/public/get-branches'); // Call the backend API to fetch branches
        const data = await res.json();

        if (data.branches) {
            const branchList = document.getElementById("branchList");
            branchList.innerHTML = "";  // Clear existing branches
            
            // Dynamically create the branch list items
            data.branches.forEach(branch => {
                const branchItem = document.createElement("div");
                branchItem.className = "branch-item";
                branchItem.textContent = branch.name;

                // Add click listener to change the branch
                branchItem.onclick = () => switchBranch(branch.name);
                branchList.appendChild(branchItem);
            });
        }
    } catch (error) {
        console.error('Error fetching branches:', error);
    } finally {
        hideLoader();
    }
};

// Switch to a different branch and update the repo content
const switchBranch = async (branchName) => {
    currentBranch = branchName;  // Update current branch
    document.getElementById("current-branch-text").textContent = branchName;

    // Fetch the repository content for the new branch
    fetchRepoStructure("" , branchName);  // Assuming fetchRepoStructure() is a function to load repo content
};

// Function to display files based on the selected branch (Fetch file content and repo structure)


// Function to toggle the dropdown (open/close)
const toggleDropdown = () => {
    const dropdownContent = document.getElementById("dropdownContent");
    dropdownContent.classList.toggle("show");  // Toggle "show" class to control visibility
};


// Function to show loading indicator
const showLoader = () => {
    document.querySelector(".loader-placeholder").style.display = "flex";
};


const fetchCommitInfo = async () => {
    try {
        const res = await fetch('/public/get-commit-info');  // Backend API to fetch commit info
        const data = await res.json();

        if (data.authorName && data.commitMessage) {
            // Update the author name and last commit message
            document.getElementById("author-name").textContent = data.authorName;
            document.querySelector(".commit-message").textContent = data.commitMessage;

            // Update the commit count
            document.getElementById("commitCount").textContent = data.commitCount;

            // Update the commit timestamp in a "time ago" format
            document.querySelector(".header-right span:last-child").textContent = data.commitDate;

            // Update the author's avatar image
            const avatarImg = document.getElementById("author-avatar");
            if (data.avatarUrl) {
                avatarImg.src = data.avatarUrl;  // Set the src of the avatar image
                avatarImg.alt = `${data.authorName}'s avatar`;  // Optional: Set alt text for accessibility
            }
        } else {
            console.error("No commit data found");
        }
    } catch (error) {
        console.error("Error fetching commit info:", error);
    }
};


// Call fetchCommitInfo when the page loads


// Helper function to format commit timestamp in "time ago" format
const timeAgo = (timestamp) => {
    const now = new Date();
    const diffInSeconds = (now - new Date(timestamp)) / 1000;
    const diffInMinutes = diffInSeconds / 60;
    const diffInHours = diffInMinutes / 60;
    const diffInDays = diffInHours / 24;
    const diffInMonths = diffInDays / 30;
    const diffInYears = diffInMonths / 12;

    if (diffInSeconds < 60) {
        return "Just now";
    } else if (diffInMinutes < 60) {
        return `${Math.floor(diffInMinutes)} min ago`;
    } else if (diffInHours < 24) {
        return `${Math.floor(diffInHours)} hours ago`;
    } else if (diffInDays < 30) {
        return `${Math.floor(diffInDays)} days ago`;
    } else if (diffInMonths < 12) {
        return `${Math.floor(diffInMonths)} months ago`;
    } else {
        return `${Math.floor(diffInYears)} years ago`;
    }
};

// Function to hide loading indicator
const hideLoader = () => {
    document.querySelector(".loader-placeholder").style.display = "none";
};
    window.onload = () => {
        fetchRepoStructure();
        fetchBranches();
        fetchCommitInfo();
    };
</script>


<script>
    
    const token = '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'; // move to env in production

  

  

    
    
</script>

</body>
</html>
<?php /**PATH /home/mappakis/backend.mappakistan.org/resources/views/repo.blade.php ENDPATH**/ ?>